/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.MultiMediaObjectEditor;
import ancestris.modules.editors.genealogyeditor.models.MultiMediaObjectCitationsTableModel;
import ancestris.modules.editors.genealogyeditor.panels.MultimediaObjectTablePanel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.UnitOfWork;
import genj.io.InputSource;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MultimediaObjectCitationsTablePanel
extends JPanel {
    private Property mRoot;
    private Property mMultiMediaObject;
    private String mGedcomVersion = "";
    private final MultiMediaObjectCitationsTableModel multiMediaObjectCitationsTableModel = new MultiMediaObjectCitationsTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(MultimediaObjectCitationsTablePanel.class);
    private JButton addMMObjectButton;
    private JButton deleteMMObjectButton;
    private JButton editMMObjecButton;
    private JToolBar galleryToolBar;
    private JButton linkMMObjectButton;
    private JScrollPane multiMediaObjectCitationsScrollPane;
    private EditorTable multiMediaObjectCitationsTable;
    private JButton prefMediaEventButton;

    public MultimediaObjectCitationsTablePanel() {
        this.initComponents();
        this.multiMediaObjectCitationsTable.setID(MultimediaObjectCitationsTablePanel.class.getName());
        this.multiMediaObjectCitationsTable.getColumnModel().getColumn(0).setPreferredWidth(36);
        this.multiMediaObjectCitationsTable.getColumnModel().getColumn(0).setMinWidth(36);
        this.multiMediaObjectCitationsTable.getColumnModel().getColumn(0).setMaxWidth(36);
    }

    private void initComponents() {
        this.galleryToolBar = new JToolBar();
        this.addMMObjectButton = new JButton();
        this.linkMMObjectButton = new JButton();
        this.editMMObjecButton = new JButton();
        this.deleteMMObjectButton = new JButton();
        this.prefMediaEventButton = new JButton();
        this.multiMediaObjectCitationsScrollPane = new JScrollPane();
        this.multiMediaObjectCitationsTable = new EditorTable();
        this.setMinimumSize(new Dimension(453, 57));
        this.galleryToolBar.setFloatable(false);
        this.galleryToolBar.setRollover(true);
        this.galleryToolBar.setPreferredSize(new Dimension(453, 57));
        this.addMMObjectButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addMMObjectButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("MultimediaObjectCitationsTablePanel.addMMObjectButton.toolTipText"), new Object[0]));
        this.addMMObjectButton.setFocusable(false);
        this.addMMObjectButton.setHorizontalTextPosition(0);
        this.addMMObjectButton.setVerticalTextPosition(3);
        this.addMMObjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultimediaObjectCitationsTablePanel.this.addMMObjectButtonActionPerformed(evt);
            }
        });
        this.galleryToolBar.add(this.addMMObjectButton);
        this.linkMMObjectButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkMMObjectButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("MultimediaObjectCitationsTablePanel.linkMMObjectButton.toolTipText"), new Object[0]));
        this.linkMMObjectButton.setFocusable(false);
        this.linkMMObjectButton.setHorizontalTextPosition(0);
        this.linkMMObjectButton.setVerticalTextPosition(3);
        this.linkMMObjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultimediaObjectCitationsTablePanel.this.linkMMObjectButtonActionPerformed(evt);
            }
        });
        this.galleryToolBar.add(this.linkMMObjectButton);
        this.editMMObjecButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editMMObjecButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("MultimediaObjectCitationsTablePanel.editMMObjecButton.toolTipText"), new Object[0]));
        this.editMMObjecButton.setFocusable(false);
        this.editMMObjecButton.setHorizontalTextPosition(0);
        this.editMMObjecButton.setVerticalTextPosition(3);
        this.editMMObjecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultimediaObjectCitationsTablePanel.this.editMMObjecButtonActionPerformed(evt);
            }
        });
        this.galleryToolBar.add(this.editMMObjecButton);
        this.deleteMMObjectButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteMMObjectButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("MultimediaObjectCitationsTablePanel.deleteMMObjectButton.toolTipText"), new Object[0]));
        this.deleteMMObjectButton.setFocusable(false);
        this.deleteMMObjectButton.setHorizontalTextPosition(0);
        this.deleteMMObjectButton.setVerticalTextPosition(3);
        this.deleteMMObjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultimediaObjectCitationsTablePanel.this.deleteMMObjectButtonActionPerformed(evt);
            }
        });
        this.galleryToolBar.add(this.deleteMMObjectButton);
        this.prefMediaEventButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/star.png")));
        this.prefMediaEventButton.setText(NbBundle.getMessage(MultimediaObjectCitationsTablePanel.class, (String)"MultimediaObjectCitationsTablePanel.prefMediaEventButton.text"));
        this.prefMediaEventButton.setToolTipText(NbBundle.getMessage(MultimediaObjectCitationsTablePanel.class, (String)"MultimediaObjectCitationsTablePanel.prefMediaEventButton.toolTipText"));
        this.prefMediaEventButton.setIconTextGap(0);
        this.prefMediaEventButton.setPreferredSize(new Dimension(16, 16));
        this.prefMediaEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultimediaObjectCitationsTablePanel.this.prefMediaEventButtonActionPerformed(evt);
            }
        });
        this.galleryToolBar.add(this.prefMediaEventButton);
        this.multiMediaObjectCitationsTable.setModel(this.multiMediaObjectCitationsTableModel);
        this.multiMediaObjectCitationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MultimediaObjectCitationsTablePanel.this.multiMediaObjectCitationsTableMouseClicked(evt);
            }
        });
        this.multiMediaObjectCitationsScrollPane.setViewportView(this.multiMediaObjectCitationsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.galleryToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.multiMediaObjectCitationsScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.galleryToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multiMediaObjectCitationsScrollPane, -2, 26, Short.MAX_VALUE)));
    }

    private void addMMObjectButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    if (MultimediaObjectCitationsTablePanel.this.mGedcomVersion.equals("5.5.1")) {
                        MultimediaObjectCitationsTablePanel.this.mMultiMediaObject = (Property)MultimediaObjectCitationsTablePanel.this.mRoot.getGedcom().createEntity("OBJE");
                        MultimediaObjectCitationsTablePanel.this.mRoot.addMedia((Media)MultimediaObjectCitationsTablePanel.this.mMultiMediaObject);
                    } else {
                        MultimediaObjectCitationsTablePanel.this.mMultiMediaObject = MultimediaObjectCitationsTablePanel.this.mRoot.addProperty("OBJE", "");
                    }
                }
            });
            MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
            multiMediaObjectEditor.setContext(new Context(this.mMultiMediaObject));
            multiMediaObjectEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(multiMediaObjectEditor);
            if (multiMediaObjectEditor.showPanel()) {
                this.multiMediaObjectCitationsTableModel.clear();
                this.multiMediaObjectCitationsTableModel.addAll(Arrays.asList(this.mRoot.getProperties("OBJE")));
                int row = this.multiMediaObjectCitationsTableModel.getRowOf(this.mMultiMediaObject);
                this.multiMediaObjectCitationsTable.getSelectionModel().setSelectionInterval(row, row);
                this.editMMObjecButton.setEnabled(true);
                this.deleteMMObjectButton.setEnabled(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            multiMediaObjectEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)multiMediaObjectEditor);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void deleteMMObjectButtonActionPerformed(ActionEvent evt) {
        Property multiMediaObjectRef;
        Property file;
        String objectName;
        DialogManager createYesNo;
        int selectedRow = this.multiMediaObjectCitationsTable.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int rowIndex = this.multiMediaObjectCitationsTable.convertRowIndexToModel(selectedRow);
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(MultimediaObjectCitationsTablePanel.class, (String)"MultimediaObjectCitationsTableDialog.deleteObjectConfirmation.title", (Object)(objectName = (file = (multiMediaObjectRef = this.multiMediaObjectCitationsTableModel.getValueAt(rowIndex)).getProperty("FILE", false)) != null && file instanceof PropertyFile ? ((InputSource)((PropertyFile)file).getInput().get()).getLocation() : (multiMediaObjectRef instanceof PropertyMedia ? ((PropertyMedia)multiMediaObjectRef).getTargetEntity().getId() : " "))), (String)NbBundle.getMessage(MultimediaObjectCitationsTablePanel.class, (String)"MultimediaObjectCitationsTableDialog.deleteObjectConfirmation.text", (Object)objectName, (Object)this.mRoot))).show() == DialogManager.YES_OPTION) {
            try {
                this.multiMediaObjectCitationsTableModel.remove(rowIndex);
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        MultimediaObjectCitationsTablePanel.this.mRoot.delProperty(multiMediaObjectRef);
                    }
                });
                if (this.multiMediaObjectCitationsTableModel.getRowCount() <= 0) {
                    this.editMMObjecButton.setEnabled(false);
                    this.deleteMMObjectButton.setEnabled(false);
                }
                this.changeSupport.fireChange();
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void editMMObjecButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.multiMediaObjectCitationsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.multiMediaObjectCitationsTable.convertRowIndexToModel(selectedRow);
            Property multiMediaObject = this.multiMediaObjectCitationsTableModel.getValueAt(rowIndex);
            MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
            multiMediaObjectEditor.setContext(new Context(multiMediaObject));
            multiMediaObjectEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mRoot.getGedcom());
            atc.getOpenEditors().add(multiMediaObjectEditor);
            if (multiMediaObjectEditor.showPanel()) {
                this.multiMediaObjectCitationsTable.tableChanged(null);
            }
            multiMediaObjectEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)multiMediaObjectEditor);
        }
    }

    private void multiMediaObjectCitationsTableMouseClicked(MouseEvent evt) {
        int selectedRow;
        if (evt.getClickCount() >= 2 && (selectedRow = this.multiMediaObjectCitationsTable.getSelectedRow()) != -1) {
            int rowIndex = this.multiMediaObjectCitationsTable.convertRowIndexToModel(selectedRow);
            Property multiMediaObject = this.multiMediaObjectCitationsTableModel.getValueAt(rowIndex);
            MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
            multiMediaObjectEditor.setContext(new Context(multiMediaObject));
            multiMediaObjectEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mRoot.getGedcom());
            atc.getOpenEditors().add(multiMediaObjectEditor);
            if (multiMediaObjectEditor.showPanel()) {
                this.multiMediaObjectCitationsTable.tableChanged(null);
            }
            multiMediaObjectEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)multiMediaObjectEditor);
        }
    }

    private void linkMMObjectButtonActionPerformed(ActionEvent evt) {
        ArrayList<Media> notesList = new ArrayList<Media>(this.mRoot.getGedcom().getEntities("OBJE"));
        MultimediaObjectTablePanel multimediaObjectTablePanel = new MultimediaObjectTablePanel(this.mRoot, notesList);
        DialogManager.ADialog multimediaObjectTableDialog = new DialogManager.ADialog(NbBundle.getMessage(MultimediaObjectTablePanel.class, (String)"MultimediaObjectTableDialog.linkTo.title"), (JComponent)multimediaObjectTablePanel);
        multimediaObjectTableDialog.setDialogId(MultimediaObjectTablePanel.class.getName());
        if (multimediaObjectTableDialog.show() == DialogDescriptor.OK_OPTION) {
            final Media selectedMultimediaObject = multimediaObjectTablePanel.getSelectedMultiMediaObject();
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        MultimediaObjectCitationsTablePanel.this.mRoot.addMedia(selectedMultimediaObject);
                    }
                });
                this.multiMediaObjectCitationsTableModel.clear();
                this.multiMediaObjectCitationsTableModel.addAll(Arrays.asList(this.mRoot.getProperties("OBJE")));
                int row = this.multiMediaObjectCitationsTableModel.getRowOf((Property)selectedMultimediaObject);
                this.multiMediaObjectCitationsTable.getSelectionModel().setSelectionInterval(row, row);
                this.editMMObjecButton.setEnabled(true);
                this.deleteMMObjectButton.setEnabled(true);
                this.changeSupport.fireChange();
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        multimediaObjectTablePanel.saveFilterSettings();
    }

    private void prefMediaEventButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.multiMediaObjectCitationsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.multiMediaObjectCitationsTable.convertRowIndexToModel(selectedRow);
            final Property selectedMultimediaObject = this.multiMediaObjectCitationsTableModel.getValueAt(rowIndex);
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        Property p = selectedMultimediaObject.getParent().getProperty("OBJE");
                        int pos = selectedMultimediaObject.getParent().getPropertyPosition(p);
                        selectedMultimediaObject.getParent().moveProperty(selectedMultimediaObject, pos);
                    }
                });
                this.multiMediaObjectCitationsTableModel.clear();
                this.multiMediaObjectCitationsTableModel.addAll(Arrays.asList(this.mRoot.getProperties("OBJE")));
                int row = this.multiMediaObjectCitationsTableModel.getRowOf(selectedMultimediaObject);
                this.multiMediaObjectCitationsTable.getSelectionModel().setSelectionInterval(row, row);
                this.editMMObjecButton.setEnabled(true);
                this.deleteMMObjectButton.setEnabled(true);
                this.changeSupport.fireChange();
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void set(Property root, List<Property> multiMediasList) {
        if (root == null) {
            return;
        }
        this.mGedcomVersion = root.getGedcom().getGrammar().getVersion();
        this.mRoot = root;
        this.multiMediaObjectCitationsTableModel.clear();
        this.multiMediaObjectCitationsTableModel.addAll(multiMediasList);
        if (this.multiMediaObjectCitationsTableModel.getRowCount() > 0) {
            this.editMMObjecButton.setEnabled(true);
            this.deleteMMObjectButton.setEnabled(true);
            this.multiMediaObjectCitationsTable.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.editMMObjecButton.setEnabled(false);
            this.deleteMMObjectButton.setEnabled(false);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            MultimediaObjectCitationsTablePanel.this.changeSupport.fireChange();
        }
    }
}

