/*
 * Decompiled with CFR 0.152.
 */
package ancestris.tour;

import ancestris.api.sample.SampleProvider;
import ancestris.app.ActionClose;
import ancestris.app.ActionOpen;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.explorer.GedcomExplorerTopComponent;
import ancestris.gedcom.GedcomDirectory;
import ancestris.tour.TourPanel;
import ancestris.util.swing.DialogManager;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.AncestrisViewInterface;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import gj.awt.geom.Path;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TourAction
implements ActionListener {
    private boolean transluscentIsSupported = true;
    private final int ARROW = 80;
    private final int SMALLGAP = 20;
    private final int GAP = 100;
    private final String DEMOFILE = "bourbon";
    private TopComponent welcome;
    private int numDemo;
    private boolean componentToBeClosed = false;
    private Frame mainWindow;

    @Override
    public void actionPerformed(ActionEvent e) {
        Logger LOG = Logger.getLogger("ancestris.guided_tour");
        this.mainWindow = WindowManager.getDefault().getMainWindow();
        GraphicsDevice graphdev = this.mainWindow.getGraphicsConfiguration().getDevice();
        if (!graphdev.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            LOG.info("Guided Tour : translucency not supported. Will use opaque windows instead.");
            this.transluscentIsSupported = false;
        }
        this.welcome = this.showTopComponent(null, "Welcome");
        this.mainWindow.setExtendedState(6);
        this.numDemo = 0;
        boolean stop = this.demoIntro();
        if (stop) {
            return;
        }
        boolean wasOpen = false;
        boolean found = false;
        Collection files = AncestrisPlugin.lookupAll(SampleProvider.class);
        for (SampleProvider sample : files) {
            if (!sample.getSampleGedcomFile().getName().toLowerCase().contains("bourbon")) continue;
            found = true;
            List loadedContexts = GedcomDirectory.getDefault().getContexts();
            for (Context context : loadedContexts) {
                Gedcom gedcom = context.getGedcom();
                if (!gedcom.getName().toLowerCase().contains("bourbon")) continue;
                wasOpen = true;
            }
            if (wasOpen) break;
            this.setWait();
            new ActionOpen(FileUtil.toFileObject((File)sample.getSampleGedcomFile())).actionPerformed(e);
            this.setWaitNot();
            break;
        }
        if (!found) {
            LOG.info("Guided Tour : Bourbon module not installed. Required.");
            String title = NbBundle.getMessage(this.getClass(), (String)"error.noBourbonTitl");
            String msg = NbBundle.getMessage(this.getClass(), (String)"error.noBourbonMsg");
            DialogManager.create((String)title, (String)msg).setMessageType(0).setOptionType(10).setResizable(false).show();
            return;
        }
        stop = this.demoWindows();
        if (!stop) {
            stop = this.demoMenu();
        }
        if (!stop) {
            stop = this.demoMenuview();
        }
        if (!stop) {
            stop = this.demoMenutools();
        }
        if (!stop) {
            stop = this.demoProperties();
        }
        if (!stop) {
            stop = this.demoEdition();
        }
        if (!stop) {
            stop = this.demoWindow();
        }
        if (!stop) {
            stop = this.demoMenuOptions();
        }
        if (!stop) {
            stop = this.demoMenuhelp();
        }
        if (!stop) {
            stop = this.demoExplorer();
        }
        if (!stop) {
            stop = this.demoTree();
        }
        if (!stop) {
            stop = this.demoCygnus();
        }
        if (!stop) {
            stop = this.demoGedcom();
        }
        if (!stop) {
            stop = this.demoAries();
        }
        if (!stop) {
            stop = this.demoGeo();
        }
        if (!stop) {
            stop = this.demoChrono();
        }
        if (!stop) {
            stop = this.demoTable();
        }
        if (!stop) {
            stop = this.demoSearch();
        }
        if (!wasOpen) {
            List loadedContexts = GedcomDirectory.getDefault().getContexts();
            for (Context context : loadedContexts) {
                Gedcom gedcom = context.getGedcom();
                if (!gedcom.getName().toLowerCase().contains("bourbon")) continue;
                this.setWait();
                new ActionClose(context).actionPerformed(e);
                this.setWaitNot();
            }
        }
        if (!stop) {
            this.demoClose();
        }
    }

    private boolean demoIntro() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.intro");
        Color bgcolor = Color.BLACK;
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(500, 300);
        TranslucentPopup popup = new TranslucentPopup(true, true, -1, bgcolor, fgcolor, text, null, dim, 20, 20, this.welcome, false);
        popup.init();
        return this.showPopUp(popup, null);
    }

    private boolean demoClose() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.close");
        Color bgcolor = Color.BLACK;
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(500, 420);
        TranslucentPopup popup = new TranslucentPopup(true, true, -1, bgcolor, fgcolor, text, null, dim, 20, 20, this.welcome, true);
        popup.init();
        return this.showPopUp(popup, null);
    }

    private boolean demoWindows() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.windows");
        Color bgcolor = new Color(14079);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(680, 440);
        TranslucentPopup popup = new TranslucentPopup(true, true, -1, bgcolor, fgcolor, text, null, dim, 20, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, null);
        return stop;
    }

    private boolean demoMenu() {
        JMenuBar mb = this.getMenuBar();
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.menu");
        Color bgcolor = new Color(14079);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(780, 480);
        Window w = this.getWindow(new Color(0, 54, 255, 50), Color.RED, 0, 50, 580, 80, 3, 3);
        TranslucentPopup popup = new TranslucentPopup(true, false, 0, bgcolor, fgcolor, text, new Point(360, 135), dim, 100, 20, this.welcome, false);
        popup.init();
        if (this.transluscentIsSupported) {
            w.setVisible(true);
        }
        boolean stop = this.showPopUp(popup, mb);
        if (this.transluscentIsSupported) {
            w.setVisible(false);
        }
        return stop;
    }

    private boolean demoMenuview() {
        JMenu m = this.getMenu(2);
        m.setSelected(true);
        m.setPopupMenuVisible(true);
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.menuview");
        Color bgcolor = new Color(162665);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(680, 240);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(260, 260), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, m);
        m.setSelected(false);
        m.setPopupMenuVisible(false);
        return stop;
    }

    private boolean demoMenutools() {
        JMenu m = this.getMenu(3);
        m.setSelected(true);
        m.setPopupMenuVisible(true);
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.menutools");
        Color bgcolor = new Color(5177979);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(700, 370);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(460, 170), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, m);
        m.setSelected(false);
        m.setPopupMenuVisible(false);
        return stop;
    }

    private boolean demoProperties() {
        JMenu m = this.getMenu(0);
        m.setSelected(true);
        m.setPopupMenuVisible(true);
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.properties");
        Color bgcolor = new Color(6567424);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(680, 400);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(250, 200), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, m);
        m.setSelected(false);
        m.setPopupMenuVisible(false);
        return stop;
    }

    private boolean demoEdition() {
        JMenu m = this.getMenu(1);
        m.setSelected(true);
        m.setPopupMenuVisible(true);
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.edition");
        Color bgcolor = new Color(0x802000);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(640, 360);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(280, 210), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, m);
        m.setSelected(false);
        m.setPopupMenuVisible(false);
        return stop;
    }

    private boolean demoWindow() {
        JMenu m = this.getMenu(4);
        m.setSelected(true);
        m.setPopupMenuVisible(true);
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.window");
        Color bgcolor = new Color(0x508000);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(450, 200);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(410, 180), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, m);
        m.setSelected(false);
        m.setPopupMenuVisible(false);
        return stop;
    }

    private boolean demoMenuOptions() {
        JMenu m = this.getMenu(5);
        m.setSelected(true);
        m.setPopupMenuVisible(true);
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.menuoptions");
        Color bgcolor = new Color(14079);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(590, 410);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(520, 160), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, m);
        m.setSelected(false);
        m.setPopupMenuVisible(false);
        return stop;
    }

    private boolean demoMenuhelp() {
        JMenu m = this.getMenu(6);
        m.setSelected(true);
        m.setPopupMenuVisible(true);
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.menuhelp");
        Color bgcolor = new Color(18697);
        Color fgcolor = Color.WHITE;
        Dimension dim = new Dimension(680, 380);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(530, 160), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean stop = this.showPopUp(popup, m);
        m.setSelected(false);
        m.setPopupMenuVisible(false);
        return stop;
    }

    private boolean demoExplorer() {
        GedcomExplorerTopComponent demo = GedcomExplorerTopComponent.findInstance();
        demo.expandCollapse(true);
        demo.requestActive();
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.explorer");
        Color bgcolor = new Color(6143231);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(650, 410);
        TranslucentPopup popup = new TranslucentPopup(true, false, 15, bgcolor, fgcolor, text, new Point(0, 0), dim, 100, 20, this.welcome, false);
        popup.init();
        boolean next = this.showPopUp(popup, (Component)((Object)demo));
        demo.expandCollapse(true);
        return next;
    }

    private boolean demoTree() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.tree");
        Color bgcolor = new Color(12381352);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(700, 420);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(0, 0), dim, 100, 20, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "TreeTopComponent");
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private boolean demoCygnus() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.cygnus");
        Color bgcolor = new Color(11062764);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(900, 500);
        TranslucentPopup popup = new TranslucentPopup(false, false, 20, bgcolor, fgcolor, text, new Point(0, 0), dim, 20, 100, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "CygnusTopComponent");
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private boolean demoGedcom() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.gedcom");
        Color bgcolor = new Color(12495084);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(800, 480);
        TranslucentPopup popup = new TranslucentPopup(false, false, 20, bgcolor, fgcolor, text, new Point(0, 0), dim, 20, 100, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "GedcomTopComponent");
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private boolean demoAries() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.aries");
        Color bgcolor = new Color(15461544);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(800, 380);
        TranslucentPopup popup = new TranslucentPopup(false, false, 20, bgcolor, fgcolor, text, new Point(0, 0), dim, 20, 100, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "AriesTopComponent");
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private boolean demoGeo() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.geo");
        Color bgcolor = new Color(14919916);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(800, 550);
        TranslucentPopup popup = new TranslucentPopup(true, false, 60, bgcolor, fgcolor, text, new Point(0, 0), dim, 100, 20, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "GeoMapTopComponent");
        if (!demo.isOpened()) {
            return false;
        }
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private boolean demoChrono() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.chrono");
        Color bgcolor = new Color(11068396);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(650, 330);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(0, 0), dim, 100, 20, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "TimelineTopComponent");
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private boolean demoTable() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.table");
        Color bgcolor = new Color(6155690);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(800, 420);
        TranslucentPopup popup = new TranslucentPopup(false, false, 20, bgcolor, fgcolor, text, new Point(0, 0), dim, 20, 100, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "TableTopComponent");
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private boolean demoSearch() {
        String text = NbBundle.getMessage(this.getClass(), (String)"demo.search");
        Color bgcolor = new Color(15516072);
        Color fgcolor = Color.BLACK;
        Dimension dim = new Dimension(800, 480);
        TranslucentPopup popup = new TranslucentPopup(true, false, 20, bgcolor, fgcolor, text, new Point(0, 0), dim, 100, 20, this.welcome, false);
        popup.init();
        TopComponent demo = this.showTopComponent(popup, "GedcomCompareTopComponent");
        boolean next = this.showPopUp(popup, (Component)demo);
        if (this.componentToBeClosed) {
            demo.close();
        }
        return next;
    }

    private Shape getBubble(boolean isLeft, boolean isTop, Dimension d, boolean isCurved, int offset) {
        int w = d.width;
        int h = d.height;
        int wq = 80;
        int hq = h / 5;
        int corners = 50;
        GeneralPath path = new GeneralPath();
        Path shape = null;
        if (isLeft && isTop) {
            path.moveTo(wq, 2 * hq);
            if (isCurved) {
                path.curveTo(wq, 2 * hq, 0.0f, 2 * hq, 0.0f, offset);
                path.curveTo(0.0f, offset, 0.0f, hq, wq, 1 * hq);
            } else {
                path.lineTo(0.0f, offset);
                path.lineTo(wq, 1 * hq);
            }
            shape = new Path().append((Shape)new RoundRectangle2D.Double(wq, 0.0, w - wq, h, corners, corners));
        } else if (!isLeft && isTop) {
            path.moveTo(w - wq, 2 * hq);
            if (isCurved) {
                path.curveTo(w - wq, 2 * hq, w, 2 * hq, w, offset);
                path.curveTo(w, offset, w, hq, w - wq, 1 * hq);
            } else {
                path.lineTo(w, offset);
                path.lineTo(w - wq, hq);
            }
            shape = new Path().append((Shape)new RoundRectangle2D.Double(0.0, 0.0, w - wq, h, corners, corners));
        } else if (isLeft && !isTop) {
            path.moveTo(wq, h - 2 * hq);
            if (isCurved) {
                path.curveTo(wq, h - 2 * hq, 0.0f, h - 2 * hq, 0.0f, h - offset);
                path.curveTo(0.0f, h - offset, 0.0f, h - hq, wq, h - hq);
            } else {
                path.lineTo(0.0f, h - offset);
                path.lineTo(wq, h - 1 * hq);
            }
            shape = new Path().append((Shape)new RoundRectangle2D.Double(wq, 0.0, w - wq, h, corners, corners));
        } else if (!isLeft && !isTop) {
            path.moveTo(w - wq, h - hq);
            if (isCurved) {
                path.curveTo(w - wq, h - hq, w, h - hq, w, h - offset);
                path.curveTo(w, h - offset, w, h - 2 * hq, w - wq, h - 2 * hq);
            } else {
                path.lineTo(w, h - offset);
                path.lineTo(w - wq, h - 2 * hq);
            }
            shape = new Path().append((Shape)new RoundRectangle2D.Double(0.0, 0.0, w - wq, h, corners, corners));
        }
        path.append((Shape)shape, true);
        path.closePath();
        return path.createTransformedShape(new AffineTransform());
    }

    private JMenuBar getMenuBar() {
        Component[] cs = this.mainWindow.getComponents();
        JRootPane rp = (JRootPane)cs[0];
        return rp.getJMenuBar();
    }

    private JMenu getMenu(int index) {
        JMenuBar mb = this.getMenuBar();
        return mb.getMenu(index);
    }

    private void setWait() {
        this.mainWindow.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setWaitNot() {
        this.mainWindow.setCursor(Cursor.getPredefinedCursor(0));
    }

    private Window getWindow(Color color, final Color colorBox, int x, int y, final int width, final int height, final int arcWidth, final int arcHeight) {
        Window w = new Window(this.mainWindow){

            @Override
            public void paint(Graphics g) {
                int b = 3;
                g.setColor(colorBox);
                ((Graphics2D)g).setStroke(new BasicStroke(b));
                g.drawRoundRect(arcWidth + b, arcHeight + b, width - 2 * (arcWidth + b), height - 2 * (arcHeight + b), arcWidth, arcHeight);
            }

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        w.setAlwaysOnTop(true);
        Point currentLocation = this.mainWindow.getLocationOnScreen();
        currentLocation.setLocation(currentLocation.getX() + (double)x, currentLocation.getY() + (double)y);
        w.setLocation(currentLocation);
        w.setSize(width, height);
        if (this.transluscentIsSupported) {
            w.setBackground(color);
            w.setOpacity(0.3f);
        }
        return w;
    }

    private TopComponent showTopComponent(TranslucentPopup tp, String str) {
        for (TopComponent tcItem : WindowManager.getDefault().getRegistry().getOpened()) {
            String p = tcItem.getClass().getName();
            String n = tcItem.getName().toLowerCase();
            if (!p.contains(str) || tcItem instanceof AncestrisTopComponent && !n.contains("bourbon".toLowerCase())) continue;
            this.componentToBeClosed = false;
            this.activateTopComponent(tcItem, tp);
            return tcItem;
        }
        TopComponent tc = null;
        this.setWait();
        Collection listTmp = Lookup.getDefault().lookupAll(AncestrisViewInterface.class);
        List list = (List)Lookup.getDefault().lookupAll(TopComponent.class);
        for (TopComponent tcItem : list) {
            String p = tcItem.getClass().getName();
            if (!p.contains(str)) continue;
            if (tcItem instanceof AncestrisTopComponent) {
                List contexts = GedcomDirectory.getDefault().getContexts();
                if (contexts.isEmpty()) continue;
                Context contextToOpen = (Context)contexts.get(0);
                for (Context c : contexts) {
                    if (!c.getGedcom().getName().contains("bourbon")) continue;
                    contextToOpen = c;
                    break;
                }
                tc = ((AncestrisTopComponent)tcItem).create(contextToOpen);
            } else {
                tc = tcItem;
            }
            tc.open();
            this.componentToBeClosed = true;
            break;
        }
        this.setWaitNot();
        this.activateTopComponent(tc, tp);
        return tc;
    }

    private void activateTopComponent(final TopComponent tc, final TranslucentPopup tp) {
        if (tc != null) {
            tc.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    if (tp != null) {
                        tp.setPositionDimension((Component)tc);
                    }
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            tc.requestActive();
        }
    }

    private boolean showPopUp(TranslucentPopup tp, Component tc) {
        tp.setPositionDimension(tc);
        tp.showDialog();
        return tp.exit;
    }

    private class TranslucentPopup
    extends JDialog
    implements KeyListener {
        private final JDialog me;
        private boolean exit;
        private TourPanel panel;
        private Dimension screenSize;
        private TopComponent back;
        private boolean pointerLeftParam;
        private boolean pointerTopParam;
        private boolean isCurvedParam;
        private int pointerOffsetParam;
        private Point pParam;
        private Dimension dParam;
        private Color bgcolorParam;
        private Color fgcolorParam;
        private String textParam;
        private int gapLParam;
        private int gapRParam;
        private boolean endParam;

        public TranslucentPopup(boolean isLeft, boolean isCurved, int offset, Color bgcolor, Color fgcolor, String text, Point p, Dimension d, int gapL, int gapR, TopComponent back, boolean end) {
            super(TourAction.this.mainWindow);
            this.exit = true;
            this.panel = null;
            this.me = this;
            this.back = back;
            this.dParam = d;
            this.pointerLeftParam = isLeft;
            this.isCurvedParam = isCurved;
            this.pointerOffsetParam = offset;
            this.bgcolorParam = bgcolor;
            this.fgcolorParam = fgcolor;
            this.textParam = text;
            this.gapLParam = gapL;
            this.gapRParam = gapR;
            this.endParam = end;
            Point currentLocation = TourAction.this.mainWindow.getLocationOnScreen();
            GraphicsDevice graphdev = TourAction.this.mainWindow.getGraphicsConfiguration().getDevice();
            this.screenSize = currentLocation.getX() > 100.0 ? new Dimension(graphdev.getDisplayMode().getWidth(), graphdev.getDisplayMode().getHeight()) : Toolkit.getDefaultToolkit().getScreenSize();
            if (p != null) {
                currentLocation.setLocation(p.getX() + currentLocation.getX(), p.getY() + currentLocation.getY());
            } else {
                currentLocation.setLocation((double)((this.screenSize.width - this.dParam.width) / 2) + currentLocation.getX(), (double)((this.screenSize.height - this.dParam.height) / 2) + currentLocation.getY());
            }
            this.pParam = currentLocation;
        }

        public void init() {
            this.setModal(true);
            this.setDefaultCloseOperation(0);
            this.setUndecorated(true);
            this.setResizable(false);
            this.addKeyListener(this);
            if (TourAction.this.transluscentIsSupported) {
                this.me.setOpacity(0.9f);
            }
            TourAction.this.numDemo++;
            this.addBubble();
        }

        public void addBubble() {
            this.panel = new TourPanel(TourAction.this.numDemo, this.textParam, this.bgcolorParam, this.fgcolorParam, this.gapLParam, this.gapRParam, this.endParam){

                @Override
                public void closeDemo(boolean set) {
                    TranslucentPopup.this.me.dispose();
                    if (TranslucentPopup.this.back != null) {
                        TranslucentPopup.this.back.requestActive();
                    }
                    TranslucentPopup.this.exit = set;
                }
            };
            this.getContentPane().add(this.panel);
        }

        public void removeBubble() {
            if (this.panel != null) {
                this.getContentPane().remove(this.panel);
            }
        }

        private void setPositionDimension(Component demo) {
            boolean isTC = false;
            Point pTC = null;
            Dimension dTC = null;
            if (demo != null && demo instanceof TopComponent) {
                isTC = true;
            }
            this.pointerTopParam = true;
            if (demo != null && demo.isShowing() && demo.getBounds().width != 0 && isTC) {
                pTC = demo.getLocationOnScreen();
                dTC = new Dimension(demo.getBounds().width, demo.getBounds().height);
                this.pParam.x = pTC.x + dTC.width / 2;
                this.pParam.y = pTC.y + dTC.height / 2;
                boolean bl = this.pointerLeftParam = (double)this.pParam.x - TourAction.this.mainWindow.getLocationOnScreen().getX() <= (double)(this.screenSize.width / 2);
                if (this.pointerLeftParam) {
                    this.gapLParam = 100;
                    this.gapRParam = 20;
                } else {
                    this.pParam.x -= this.dParam.width;
                    this.gapLParam = 20;
                    this.gapRParam = 100;
                }
                boolean bl2 = this.pointerTopParam = (double)this.pParam.y - TourAction.this.mainWindow.getLocationOnScreen().getY() <= (double)(this.screenSize.height / 2);
                if (!this.pointerTopParam) {
                    this.pParam.y -= this.dParam.height;
                }
                this.removeBubble();
                this.addBubble();
            }
            this.setLocation(this.pParam);
            Shape bubble = null;
            bubble = this.pointerOffsetParam == -1 ? new Path().append((Shape)new RoundRectangle2D.Double(0.0, 0.0, this.dParam.width, this.dParam.height, 50.0, 50.0)) : TourAction.this.getBubble(this.pointerLeftParam, this.pointerTopParam, this.dParam, this.isCurvedParam, this.pointerOffsetParam);
            this.setShape(bubble);
        }

        private void showDialog() {
            this.pack();
            this.setSize(this.dParam);
            this.me.setVisible(true);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (10 == e.getKeyCode()) {
                this.panel.closeDemo(false);
            }
            if (27 == e.getKeyCode()) {
                this.panel.closeDemo(true);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

