/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.releve.ReleveTopComponent;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanGroup;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.RecordModel;
import ancestris.util.Utilities;
import java.io.File;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class ReleveQuickSearch
implements SearchProvider {
    private static final AbstractRecord.FieldType[] lastNameFieldTypes = new AbstractRecord.FieldType[]{AbstractRecord.FieldType.indiLastName, AbstractRecord.FieldType.indiMarriedLastName, AbstractRecord.FieldType.indiFatherLastName, AbstractRecord.FieldType.indiMotherLastName, AbstractRecord.FieldType.wifeLastName, AbstractRecord.FieldType.wifeMarriedLastName, AbstractRecord.FieldType.wifeFatherLastName, AbstractRecord.FieldType.wifeMotherLastName, AbstractRecord.FieldType.witness1LastName, AbstractRecord.FieldType.witness2LastName, AbstractRecord.FieldType.witness3LastName, AbstractRecord.FieldType.witness4LastName};
    private static final AbstractRecord.FieldType[] firstNameFieldTypes = new AbstractRecord.FieldType[]{AbstractRecord.FieldType.indiFirstName, AbstractRecord.FieldType.indiMarriedFirstName, AbstractRecord.FieldType.indiFatherFirstName, AbstractRecord.FieldType.indiMotherFirstName, AbstractRecord.FieldType.wifeFirstName, AbstractRecord.FieldType.wifeMarriedFirstName, AbstractRecord.FieldType.wifeFatherFirstName, AbstractRecord.FieldType.wifeMotherFirstName, AbstractRecord.FieldType.witness1FirstName, AbstractRecord.FieldType.witness2FirstName, AbstractRecord.FieldType.witness3FirstName, AbstractRecord.FieldType.witness4FirstName};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        ReleveQuickSearch releveQuickSearch = this;
        synchronized (releveQuickSearch) {
            String resquestPattern = Utilities.removeDiacritics((String)request.getText().trim());
            for (ReleveTopComponent tc : AncestrisPlugin.lookupAll(ReleveTopComponent.class)) {
                this.searchInModel(tc, resquestPattern.toLowerCase(), response);
            }
        }
    }

    private void searchInModel(ReleveTopComponent tc, String resquest, SearchResponse response) {
        RecordModel model = tc.getDataManager().getDataModel();
        for (int indexRecord = 0; indexRecord < model.getRowCount(); ++indexRecord) {
            AbstractRecord record = model.getRecord(indexRecord);
            for (int i = 0; i < lastNameFieldTypes.length; ++i) {
                String resultDisplay;
                String resultSearch;
                Field lastName = record.getField(lastNameFieldTypes[i]);
                Field firstName = record.getField(firstNameFieldTypes[i]);
                if (lastName == null || firstName == null || !Utilities.wordsMatch((String)(resultSearch = Utilities.removeDiacriticsLower((String)(resultDisplay = lastName.toString() + " " + firstName.toString()))), (String)resquest)) continue;
                File file = tc.getCurrentFile();
                String filename = file != null ? file.getName() + " | " : "";
                StringBuilder sbDisplay = new StringBuilder(filename);
                sbDisplay.append(resultDisplay);
                sbDisplay.append(", ").append(BeanGroup.getGroup(record.getType(), lastNameFieldTypes[i]).getTitle());
                sbDisplay.append(", ").append(record.getFieldValue(AbstractRecord.FieldType.eventDate));
                if (!record.getCity().isBlank()) {
                    sbDisplay.append(" ").append(record.getCity());
                }
                if (response.addResult(this.createAction(tc, record, lastNameFieldTypes[i]), sbDisplay.toString())) continue;
                return;
            }
        }
    }

    private Runnable createAction(final ReleveTopComponent tc, final AbstractRecord record, final AbstractRecord.FieldType fieldType) {
        return new Runnable(){

            @Override
            public void run() {
                tc.requestVisible();
                tc.requestFocus();
                tc.selectField(record, fieldType);
            }
        };
    }
}

