/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.media;

import ancestris.modules.editors.media.MediaManagerActionPanel;
import ancestris.modules.editors.media.PathData;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.io.FileAssociation;
import genj.io.input.URLChecker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SearchRemoteFilePanel
extends JPanel {
    private PathData pd = null;
    private DefaultListModel<PropertyFile> filesModel = null;
    private boolean hasChanged;
    private JLabel filesLabel;
    private JList<PropertyFile> filesList;
    private JLabel foundLabel;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JButton openSiteButton;
    private JLabel unfoundLabel;
    private JLabel webSiteDirectoryLabel;
    private JTextField webSiteDirectoryTextField;

    public SearchRemoteFilePanel(PathData pd, String currentPath) {
        this.pd = pd;
        this.filesModel = new DefaultListModel();
        this.filesModel.clear();
        for (PropertyFile file : pd.getFiles()) {
            this.filesModel.addElement(file);
        }
        this.hasChanged = false;
        this.initComponents();
        this.filesList.setCellRenderer(new FileCellRenderer());
        this.webSiteDirectoryTextField.setText(currentPath);
        this.refreshPanel();
    }

    private void refreshPanel() {
        int total = this.filesModel.getSize();
        int found = 0;
        for (int i = 0; i < this.filesModel.getSize(); ++i) {
            PropertyFile f = this.filesModel.get(i);
            found += this.testFound(f) ? 1 : 0;
        }
        int unfound = total - found;
        this.filesLabel.setText(NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.filesLabel.text", (Object)total));
        this.foundLabel.setText(NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.foundLabel.text", (Object)found));
        this.foundLabel.setVisible(found > 0);
        this.unfoundLabel.setText(NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.unfoundLabel.text", (Object)unfound));
        this.unfoundLabel.setVisible(unfound > 0);
        this.jScrollPane1.repaint();
    }

    private void initComponents() {
        this.webSiteDirectoryLabel = new JLabel();
        this.webSiteDirectoryTextField = new JTextField();
        this.openSiteButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.filesLabel = new JLabel();
        this.foundLabel = new JLabel();
        this.unfoundLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.filesList = new JList();
        this.webSiteDirectoryLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.webSiteDirectoryLabel, (String)NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.webSiteDirectoryLabel.text"));
        this.webSiteDirectoryTextField.setEditable(false);
        this.webSiteDirectoryTextField.setText(NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.webSiteDirectoryTextField.text"));
        this.openSiteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Remote.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.openSiteButton, (String)NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.openSiteButton.text"));
        this.openSiteButton.setToolTipText(NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.openSiteButton.toolTipText"));
        this.openSiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchRemoteFilePanel.this.openSiteButtonActionPerformed(evt);
            }
        });
        this.filesLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.filesLabel.text"));
        this.foundLabel.setForeground(new Color(0, 102, 51));
        Mnemonics.setLocalizedText((JLabel)this.foundLabel, (String)NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.foundLabel.text"));
        this.unfoundLabel.setForeground(new Color(204, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.unfoundLabel, (String)NbBundle.getMessage(SearchRemoteFilePanel.class, (String)"SearchRemoteFilePanel.unfoundLabel.text"));
        this.filesList.setModel(this.filesModel);
        this.filesList.setSelectionMode(0);
        this.filesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchRemoteFilePanel.this.filesListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.filesList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.foundLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unfoundLabel)).addComponent(this.filesLabel, -1, 447, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addGap(6, 6, 6)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.webSiteDirectoryLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.webSiteDirectoryTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openSiteButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.webSiteDirectoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.webSiteDirectoryTextField).addComponent(this.openSiteButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.filesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.foundLabel).addComponent(this.unfoundLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addContainerGap()));
    }

    private void openSiteButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        boolean foundBefore = this.pd.found;
        boolean foundAfter = false;
        foundAfter = this.openUrl(this.webSiteDirectoryTextField.getText(), false);
        if (!this.hasChanged) {
            boolean bl = this.hasChanged = foundAfter != foundBefore;
        }
        if (!foundAfter) {
            this.pd.found = false;
            for (PropertyFile f : this.pd.getFiles()) {
                f.setFound(false);
            }
            this.displayErrorMessage();
        }
        this.refreshPanel();
        this.setCursor(new Cursor(0));
    }

    private void filesListMouseClicked(MouseEvent evt) {
        this.processSelection();
    }

    private void processSelection() {
        this.setCursor(new Cursor(3));
        PropertyFile f = this.filesModel.get(this.filesList.getSelectedIndex());
        boolean foundBefore = f.isFound();
        boolean foundAfter = this.openUrl(f.getValue(), true);
        if (!this.hasChanged) {
            boolean bl = this.hasChanged = foundAfter != foundBefore;
        }
        if (!foundAfter) {
            this.displayErrorMessage();
            this.pd.found = false;
        } else {
            this.pd.found = true;
        }
        f.setFound(this.pd.found);
        this.refreshPanel();
        Property prop = (Property)this.filesModel.get(this.filesList.getSelectedIndex());
        if (prop != null) {
            SelectionDispatcher.fireSelection((Context)new Context(prop));
        }
        this.setCursor(new Cursor(0));
    }

    protected boolean hasChanged() {
        return this.hasChanged;
    }

    private void displayErrorMessage() {
        String title = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"SearchRemoteFilePanel.displayPathTitle");
        String msg = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"SearchRemoteFilePanel.displayPathTitle.failureMessage");
        DialogManager.create((String)title, (String)msg).setMessageType(0).setOptionType(10).show();
    }

    private boolean openUrl(String urlString, boolean isFile) {
        URL remote = null;
        try {
            remote = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        URLChecker checker = URLChecker.createURLChecker(null, (String)urlString, (int)0);
        if (isFile && checker.isFileEmpty()) {
            return false;
        }
        URLChecker.CheckResult check = checker.run();
        boolean ret = check.getResult();
        FileAssociation.getDefault().execute(remote);
        return ret;
    }

    private boolean testFound(PropertyFile file) {
        for (PropertyFile f : this.pd.getFiles()) {
            if (!f.equals(file)) continue;
            return this.pd.found && f.isFound();
        }
        return false;
    }

    private class FileCellRenderer
    extends JLabel
    implements ListCellRenderer<PropertyFile> {
        private final Color foreground_found = new Color(55, 107, 53);
        private final Color foreground_unfound = new Color(200, 0, 0);

        public FileCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PropertyFile> list, PropertyFile value, int index, boolean isSelected, boolean cellHasFocus) {
            String filepath;
            PropertyFile file = value;
            int i = (filepath = file.getValue()).lastIndexOf(File.separator);
            Object name = filepath.substring(i >= 0 ? i + 1 : 0);
            name = (String)name + "   [" + file.getEntity().getId();
            Property pTitle = file.getParent().getProperty("TITL");
            if (pTitle == null) {
                pTitle = file.getProperty("TITL");
            }
            name = pTitle != null && !pTitle.getValue().isEmpty() ? (String)name + " / " + pTitle.getValue() + "]" : (String)name + "]";
            if (!isSelected) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(list.getBackground());
            }
            this.setForeground(SearchRemoteFilePanel.this.testFound(file) ? this.foreground_found : this.foreground_unfound);
            this.setText((String)name);
            this.setIcon(null);
            return this;
        }
    }
}

