/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.utilities.PropertyTag2Name;
import genj.gedcom.PropertyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FamilyNamesTableModel
extends AbstractTableModel {
    List<PropertyEvent> familyNamesList = new ArrayList<PropertyEvent>();
    String[] columnsName = new String[]{"Prefix", "name", "suffix"};

    @Override
    public int getRowCount() {
        return this.familyNamesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.familyNamesList.size()) {
            PropertyEvent propertyEvent = this.familyNamesList.get(row);
            if (column == 0) {
                return PropertyTag2Name.getTagName(propertyEvent.getTag());
            }
            return propertyEvent.getDate() != null ? propertyEvent.getDate().getDisplayValue() : "";
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void addAll(List<PropertyEvent> familyNamesList) {
        this.familyNamesList.addAll(familyNamesList);
        this.fireTableDataChanged();
    }

    public void add(PropertyEvent familyName) {
        this.familyNamesList.add(familyName);
        this.fireTableDataChanged();
    }

    public PropertyEvent getValueAt(int row) {
        return this.familyNamesList.get(row);
    }

    public void clear(List<PropertyEvent> familyNamesList) {
        this.familyNamesList.clear();
    }
}

