/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.panels;

import ancestris.modules.editors.aries.panels.FamiliesTablePanel;
import ancestris.modules.editors.aries.panels.IndividualsTablePanel;
import ancestris.modules.editors.aries.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.aries.panels.SourceCitationsTablePanel;
import ancestris.modules.editors.aries.utilities.PropertyTag2Name;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.values.EnumOperations;
import genj.gedcom.values.RoleEnum;
import genj.util.swing.ChoiceWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AssociationEditorPanel
extends JPanel {
    private PropertyAssociation mAssociation;
    private Entity mEntity;
    private String mEventTag = "";
    private Indi mAssociatedIndividual;
    private Fam mAssociatedFamily;
    private boolean mRelationModified = false;
    private final ChangeListner changeListner = new ChangeListner();
    private static final String[] INDIVIDUAL_EVENT_TAGS = new String[]{"", PropertyTag2Name.getTagName("BIRT"), PropertyTag2Name.getTagName("CHR"), PropertyTag2Name.getTagName("DEAT"), PropertyTag2Name.getTagName("BURI"), PropertyTag2Name.getTagName("CREM"), PropertyTag2Name.getTagName("ADOP"), PropertyTag2Name.getTagName("BAPM"), PropertyTag2Name.getTagName("BARM"), PropertyTag2Name.getTagName("BASM"), PropertyTag2Name.getTagName("BLES"), PropertyTag2Name.getTagName("CHRA"), PropertyTag2Name.getTagName("CONF"), PropertyTag2Name.getTagName("FCOM"), PropertyTag2Name.getTagName("ORDN"), PropertyTag2Name.getTagName("NATU"), PropertyTag2Name.getTagName("EMIG"), PropertyTag2Name.getTagName("IMMI"), PropertyTag2Name.getTagName("CENS"), PropertyTag2Name.getTagName("PROB"), PropertyTag2Name.getTagName("WILL"), PropertyTag2Name.getTagName("GRAD"), PropertyTag2Name.getTagName("RETI"), PropertyTag2Name.getTagName("EVEN"), PropertyTag2Name.getTagName("CAST"), PropertyTag2Name.getTagName("DSCR"), PropertyTag2Name.getTagName("EDUC"), PropertyTag2Name.getTagName("IDNO"), PropertyTag2Name.getTagName("NATI"), PropertyTag2Name.getTagName("NCHI"), PropertyTag2Name.getTagName("NMR"), PropertyTag2Name.getTagName("OCCU"), PropertyTag2Name.getTagName("PROP"), PropertyTag2Name.getTagName("RELI"), PropertyTag2Name.getTagName("RESI"), PropertyTag2Name.getTagName("SSN"), PropertyTag2Name.getTagName("TITL")};
    private static final String[] FAMILY_EVENT_TAGS = new String[]{"", PropertyTag2Name.getTagName("ANUL"), PropertyTag2Name.getTagName("CENS"), PropertyTag2Name.getTagName("DIV"), PropertyTag2Name.getTagName("DIVF"), PropertyTag2Name.getTagName("MARR"), PropertyTag2Name.getTagName("ENGA"), PropertyTag2Name.getTagName("MARB"), PropertyTag2Name.getTagName("MARC"), PropertyTag2Name.getTagName("MARL"), PropertyTag2Name.getTagName("MARS"), PropertyTag2Name.getTagName("RESI"), PropertyTag2Name.getTagName("EVEN")};
    private DefaultComboBoxModel<String> mEventsModel = new DefaultComboBoxModel();
    private JTabbedPane associationTabbedPane;
    private ButtonGroup buttonGroup1;
    private JComboBox<String> eventTypeComboBox;
    private JRadioButton famRadioButton;
    private JRadioButton indiRadioButton;
    private JLabel jLabel1;
    private JButton linkToIndividualButton;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JLabel referenceIndividualLabel;
    private JTextField referenceIndividualTextField;
    private ChoiceWidget relationChoiceWidget;
    private JLabel relationLabel;
    private SourceCitationsTablePanel sourceCitationsTablePanel;
    private JPanel sourcesPanel;

    public AssociationEditorPanel() {
        this.initComponents();
        this.relationChoiceWidget.addChangeListener((ChangeListener)this.changeListner);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.indiRadioButton = new JRadioButton();
        this.famRadioButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.referenceIndividualLabel = new JLabel();
        this.referenceIndividualTextField = new JTextField();
        this.linkToIndividualButton = new JButton();
        this.relationLabel = new JLabel();
        this.associationTabbedPane = new JTabbedPane();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.sourcesPanel = new JPanel();
        this.sourceCitationsTablePanel = new SourceCitationsTablePanel();
        this.relationChoiceWidget = new ChoiceWidget();
        this.eventTypeComboBox = new JComboBox();
        this.buttonGroup1.add(this.indiRadioButton);
        this.indiRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.indiRadioButton, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.indiRadioButton.text"));
        this.indiRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditorPanel.this.indiRadioButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.famRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.famRadioButton, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.famRadioButton.text"));
        this.famRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditorPanel.this.famRadioButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.referenceIndividualLabel, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.referenceIndividualLabel.text"));
        this.referenceIndividualTextField.setEditable(false);
        this.referenceIndividualTextField.setText(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.referenceIndividualTextField.text"));
        this.linkToIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/link_add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.linkToIndividualButton, (String)MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/panels/Bundle").getString("AssociationEditorPanel.linkToIndividualButton.text"), new Object[0]));
        this.linkToIndividualButton.setHorizontalTextPosition(0);
        this.linkToIndividualButton.setMaximumSize(new Dimension(26, 26));
        this.linkToIndividualButton.setMinimumSize(new Dimension(26, 26));
        this.linkToIndividualButton.setPreferredSize(new Dimension(26, 26));
        this.linkToIndividualButton.setVerticalTextPosition(3);
        this.linkToIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditorPanel.this.linkToIndividualButtonActionPerformed(evt);
            }
        });
        this.relationLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.relationLabel, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.relationLabel.text"));
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, notesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE)));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, notesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.noteCitationsTablePanel, -1, 162, Short.MAX_VALUE)));
        this.associationTabbedPane.addTab(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.notesPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/note.png")), this.notesPanel);
        GroupLayout sourcesPanelLayout = new GroupLayout(this.sourcesPanel);
        this.sourcesPanel.setLayout(sourcesPanelLayout);
        sourcesPanelLayout.setHorizontalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sourcesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE)));
        sourcesPanelLayout.setVerticalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sourcesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sourceCitationsTablePanel, -1, 162, Short.MAX_VALUE)));
        this.associationTabbedPane.addTab(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.sourcesPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/source.png")), this.sourcesPanel);
        this.eventTypeComboBox.setModel(this.mEventsModel);
        this.eventTypeComboBox.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/aries/panels/Bundle").getString("AssociationEditorPanel.eventTypeComboBox.toolTipText"), new Object[0]));
        this.eventTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditorPanel.this.eventTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationTabbedPane, -1, 549, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.referenceIndividualLabel, -1, -1, Short.MAX_VALUE).addComponent(this.relationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.indiRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.famRadioButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.linkToIndividualButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceIndividualTextField)).addComponent((Component)this.relationChoiceWidget, -1, -1, Short.MAX_VALUE).addComponent(this.eventTypeComboBox, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indiRadioButton).addComponent(this.famRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eventTypeComboBox, -2, 28, -2).addComponent(this.jLabel1)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.referenceIndividualLabel).addComponent(this.linkToIndividualButton, -2, 25, -2).addComponent(this.referenceIndividualTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.relationLabel).addComponent((Component)this.relationChoiceWidget, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.associationTabbedPane).addContainerGap()));
    }

    private void linkToIndividualButtonActionPerformed(ActionEvent evt) {
        if (this.indiRadioButton.isSelected()) {
            ArrayList<Indi> individualsList = new ArrayList<Indi>(this.mEntity.getGedcom().getIndis());
            IndividualsTablePanel individualsTablePanel = new IndividualsTablePanel((Property)this.mAssociation, individualsList);
            individualsTablePanel.setToolBarVisible(false);
            DialogManager.ADialog individualsTableDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualsTablePanel.class, (String)"individualsTableDialog.title.select.individual"), (JComponent)individualsTablePanel);
            individualsTableDialog.setDialogId(IndividualsTablePanel.class.getName());
            if (individualsTableDialog.show() == DialogDescriptor.OK_OPTION) {
                this.mAssociatedIndividual = individualsTablePanel.getSelectedIndividual();
                if (this.mAssociatedIndividual != null) {
                    this.referenceIndividualTextField.setText(this.mAssociatedIndividual.getName());
                    this.referenceIndividualTextField.setVisible(true);
                    this.linkToIndividualButton.setVisible(false);
                    this.mRelationModified = true;
                }
            }
            individualsTablePanel.saveFilterSettings();
        }
        if (this.famRadioButton.isSelected()) {
            ArrayList<Fam> familiesList = new ArrayList<Fam>(this.mEntity.getGedcom().getFamilies());
            FamiliesTablePanel familiesTablePanel = new FamiliesTablePanel(FamiliesTablePanel.LIST_FAM);
            familiesTablePanel.set((Property)this.mAssociation, familiesList);
            DialogManager.ADialog familiesTableDialog = new DialogManager.ADialog(NbBundle.getMessage(FamiliesTablePanel.class, (String)"familiesTableDialog.title.select.family"), (JComponent)familiesTablePanel);
            familiesTableDialog.setDialogId(FamiliesTablePanel.class.getName());
            if (familiesTableDialog.show() == DialogDescriptor.OK_OPTION) {
                this.mAssociatedFamily = familiesTablePanel.getSelectedFamily();
                this.referenceIndividualTextField.setText(this.mAssociatedFamily.getNames());
                this.referenceIndividualTextField.setVisible(true);
                this.linkToIndividualButton.setVisible(false);
                this.mRelationModified = true;
            }
            familiesTablePanel.saveFilterSettings();
        }
    }

    private void eventTypeComboBoxActionPerformed(ActionEvent evt) {
        String eventName = this.eventTypeComboBox.getSelectedItem().toString();
        String tag = this.mEventTag;
        this.mEventTag = PropertyTag2Name.getPropertyTag(eventName);
        this.mRelationModified = !this.mEventTag.equals(tag);
    }

    private void indiRadioButtonActionPerformed(ActionEvent evt) {
        this.switchMode();
    }

    private void famRadioButtonActionPerformed(ActionEvent evt) {
        this.switchMode();
    }

    private void switchMode() {
        this.mEventsModel = new DefaultComboBoxModel();
        if (this.indiRadioButton.isSelected()) {
            this.mEventsModel.addAll(Arrays.asList(INDIVIDUAL_EVENT_TAGS));
        } else {
            this.mEventsModel.addAll(Arrays.asList(FAMILY_EVENT_TAGS));
        }
        this.eventTypeComboBox.setModel(this.mEventsModel);
    }

    void set(Entity entity, PropertyAssociation association, Property event, boolean fixedEvent) {
        PropertyRelationship propertyRelationship;
        this.mEntity = entity;
        this.changeListner.mute();
        this.mAssociation = association;
        Entity targetEntity = association.getTargetEntity().orElse(null);
        if (targetEntity != null) {
            this.linkToIndividualButton.setVisible(false);
            if (targetEntity instanceof Indi) {
                Indi indi = (Indi)targetEntity;
                this.referenceIndividualTextField.setText(indi.getName());
            } else if (targetEntity instanceof Fam) {
                Fam fam = (Fam)targetEntity;
                this.referenceIndividualTextField.setText(fam.getNames());
            }
            this.referenceIndividualTextField.setVisible(true);
        } else {
            this.referenceIndividualTextField.setVisible(false);
        }
        this.indiRadioButton.setVisible(!entity.isGrammar7() && !fixedEvent);
        this.famRadioButton.setVisible(!entity.isGrammar7() && !fixedEvent);
        if (fixedEvent || entity.isGrammar7()) {
            if (entity.isGrammar7() && this.mEntity instanceof Fam || !entity.isGrammar7() && targetEntity instanceof Fam) {
                this.mEventsModel.addAll(Arrays.asList(FAMILY_EVENT_TAGS));
            } else {
                this.mEventsModel.addAll(Arrays.asList(INDIVIDUAL_EVENT_TAGS));
            }
        } else {
            this.switchMode();
        }
        this.eventTypeComboBox.setEnabled(!fixedEvent);
        if (event == null) {
            if (this.mEntity.isGrammar7()) {
                event = association.getEvent(false);
            } else {
                propertyRelationship = (PropertyRelationship)association.getProperty("RELA", false);
                if (propertyRelationship != null) {
                    this.mEventTag = propertyRelationship.getAnchor().getLast();
                }
            }
        }
        if (event != null) {
            this.mEventTag = event.getTag();
        }
        this.eventTypeComboBox.setSelectedItem(PropertyTag2Name.getTagName(this.mEventTag));
        if (this.mEntity.isGrammar7()) {
            this.relationChoiceWidget.setValues((Object[])EnumOperations.getDisplayChoices((Enum[])RoleEnum.values()));
            this.relationChoiceWidget.setText(association.getRole());
        } else {
            this.relationChoiceWidget.setValues(this.mEntity.getGedcom().getReferenceSet("RELA").getKeys());
            propertyRelationship = (PropertyRelationship)association.getProperty("RELA", false);
            if (propertyRelationship != null) {
                this.relationChoiceWidget.setText(propertyRelationship.getDisplayValue());
            }
        }
        ArrayList<Property> pList = new ArrayList<Property>();
        pList.addAll(Arrays.asList(association.getProperties("NOTE")));
        if (association.isGrammar7()) {
            pList.addAll(Arrays.asList(association.getProperties("SNOTE")));
        }
        this.noteCitationsTablePanel.set((Property)association, pList);
        this.sourceCitationsTablePanel.set((Property)association, Arrays.asList(association.getProperties("SOUR")));
        this.changeListner.unmute();
    }

    PropertyAssociation commit() {
        if (this.mRelationModified) {
            if (this.mEntity.isGrammar7() && this.eventTypeComboBox.isEnabled()) {
                Entity event = this.mEntity;
                if (!this.mEventTag.equals("INDI")) {
                    event = this.mEntity.getProperty(this.mEventTag);
                    if (event == null) {
                        event = this.mEntity.addProperty(this.mEventTag, "");
                    }
                    if (this.mAssociation.getParent() == this.mEntity) {
                        this.mEntity.delProperty((Property)this.mAssociation);
                    }
                    this.mAssociation = (PropertyAssociation)event.addProperty("ASSO", "@");
                }
            }
            if (this.mAssociation.isGrammar7()) {
                Property propRole = this.mAssociation.getProperty("ROLE", true);
                if (propRole == null) {
                    propRole = this.mAssociation.addProperty("ROLE", "");
                }
                propRole.setValue(this.relationChoiceWidget.getText());
                ((PropertyChoiceRole)propRole).alignPhrase();
            } else {
                String tag = this.indiRadioButton.isSelected() ? "INDI" : "FAM";
                String value = this.relationChoiceWidget.getText() + (String)(!this.mEventTag.isEmpty() ? " @#" + tag + ":" + this.mEventTag + "@" : "");
                PropertyRelationship propertyRelationship = (PropertyRelationship)this.mAssociation.getProperty("RELA", false);
                if (propertyRelationship == null) {
                    propertyRelationship = (PropertyRelationship)this.mAssociation.addProperty("RELA", "");
                }
                propertyRelationship.setValue(value);
            }
            if (this.indiRadioButton.isSelected() && this.mAssociatedIndividual != null) {
                this.mAssociation.setValue("@" + this.mAssociatedIndividual.getId() + "@");
                try {
                    this.mAssociation.link();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.famRadioButton.isSelected() && this.mAssociatedFamily != null) {
                this.mAssociation.setValue("@" + this.mAssociatedFamily.getId() + "@");
                try {
                    this.mAssociation.link();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return this.mAssociation;
    }

    private class ChangeListner
    implements ChangeListener {
        private boolean mute = false;

        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            if (!this.mute) {
                AssociationEditorPanel.this.mRelationModified = true;
            }
        }

        public void mute() {
            this.mute = true;
        }

        public void unmute() {
            this.mute = false;
        }
    }
}

