/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.notepad;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomFileListener;
import ancestris.modules.notepad.ContextElement;
import ancestris.modules.notepad.SearchNote;
import ancestris.modules.notepad.SearchNoteListRenderer;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.util.EnvironmentChecker;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(iconBase="ancestris/modules/notepad/resources/notepad.png", preferredID="NotePadTopComponent")
public class NotePadTopComponent
extends TopComponent
implements GedcomFileListener {
    private static final String ICON_PATH = "ancestris/modules/notepad/resources/notepad.png";
    private static final String PREFERRED_ID = "NotePadTopComponent";
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private static NotePadTopComponent factory;
    private final File dir;
    private final DefaultListModel<SearchNote> model = new DefaultListModel();
    private JButton jButtonDelete;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JComboBox<ContextElement> jComboBoxGedcom;
    private JList<SearchNote> jListNote;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSplitPane jSplitPane1;
    private JTextArea jTextArea1;
    private JToolBar jToolBar1;

    public NotePadTopComponent() {
        this.putClientProperty("TopComponentAllowDockAnywhere", Boolean.TRUE);
        this.initComponents();
        this.jListNote.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    return;
                }
                Object object = e.getSource();
                if (object instanceof JList) {
                    int previous;
                    JList list = (JList)object;
                    int selected = list.getSelectedIndex();
                    int n = previous = selected == e.getFirstIndex() ? e.getLastIndex() : e.getFirstIndex();
                    if (selected != previous && previous < NotePadTopComponent.this.model.getSize()) {
                        NotePadTopComponent.this.saveNotes(NotePadTopComponent.this.model.get(previous));
                    }
                }
            }
        });
        this.setName(NbBundle.getMessage(NotePadTopComponent.class, (String)"CTL_NotePadTopComponent"));
        this.setToolTipText(NbBundle.getMessage(NotePadTopComponent.class, (String)"HINT_NotePadTopComponent"));
        this.dir = NotePadTopComponent.getStorageDir();
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        this.jListNote.setModel(this.model);
        this.jListNote.setCellRenderer(new SearchNoteListRenderer());
        this.jComboBoxGedcom.addItem(new ContextElement("none", null));
        for (Context context : GedcomDirectory.getDefault().getContexts()) {
            this.jComboBoxGedcom.addItem(new ContextElement(context.getGedcom().getDisplayName(), context.getGedcom()));
        }
        this.jSplitPane1.setDividerLocation(Integer.parseInt(NbPreferences.forModule(NotePadTopComponent.class).get("NotePadSplitPane", "200")));
        this.loadNotes();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jToolBar1 = new JToolBar();
        this.jButtonNew = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonSave = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonDelete = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jComboBoxGedcom = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jListNote = new JList();
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NotePadTopComponent.this.jSplitPane1PropertyChange(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(0));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jToolBar1.setRollover(true);
        this.jButtonNew.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/notepad/resources/Create.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonNew, (String)NbBundle.getMessage(NotePadTopComponent.class, (String)"NotePadTopComponent.jButtonNew.text"));
        this.jButtonNew.setToolTipText(NbBundle.getMessage(NotePadTopComponent.class, (String)"NotePadTopComponent.jButtonNew.toolTipText"));
        this.jButtonNew.setHorizontalTextPosition(0);
        this.jButtonNew.setVerticalTextPosition(3);
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadTopComponent.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNew);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonSave.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/notepad/resources/save.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSave, (String)NbBundle.getMessage(NotePadTopComponent.class, (String)"NotePadTopComponent.jButtonSave.text"));
        this.jButtonSave.setToolTipText(NbBundle.getMessage(NotePadTopComponent.class, (String)"NotePadTopComponent.jButtonSave.toolTipText"));
        this.jButtonSave.setHorizontalTextPosition(0);
        this.jButtonSave.setVerticalTextPosition(3);
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadTopComponent.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSave);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonDelete.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/notepad/resources/Delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDelete, (String)NbBundle.getMessage(NotePadTopComponent.class, (String)"NotePadTopComponent.jButtonDelete.text"));
        this.jButtonDelete.setToolTipText(NbBundle.getMessage(NotePadTopComponent.class, (String)"NotePadTopComponent.jButtonDelete.toolTipText"));
        this.jButtonDelete.setHorizontalTextPosition(0);
        this.jButtonDelete.setVerticalTextPosition(3);
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadTopComponent.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDelete);
        this.jToolBar1.add(this.jSeparator2);
        this.jComboBoxGedcom.setToolTipText(NbBundle.getMessage(NotePadTopComponent.class, (String)"NotePadTopComponent.jComboBoxGedcom.toolTipText"));
        this.jToolBar1.add(this.jComboBoxGedcom);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 534, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 471, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.jScrollPane1.setMinimumSize(new Dimension(30, 30));
        this.jScrollPane1.setViewportView(this.jListNote);
        this.jListNote.setSelectionMode(0);
        this.jListNote.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                NotePadTopComponent.this.jListNoteValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListNote);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSplitPane1).addContainerGap()));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ContextElement ce = (ContextElement)this.jComboBoxGedcom.getModel().getSelectedItem();
        SearchNote nsn = new SearchNote();
        if (ce.isGlobal()) {
            this.model.addElement(nsn);
        } else {
            nsn.setGedcom(ce.getContext());
            this.model.addElement(nsn);
        }
        this.jListNote.setSelectedValue(nsn, true);
    }

    private void jListNoteValueChanged(ListSelectionEvent evt) {
        SearchNote selected = this.jListNote.getSelectedValue();
        if (selected != null) {
            this.jTextArea1.setText(selected.getContent());
            for (int i = 0; i < this.jComboBoxGedcom.getItemCount(); ++i) {
                ContextElement current = (ContextElement)this.jComboBoxGedcom.getModel().getElementAt(i);
                if (current.isGlobal() && selected.getGedcom() == null) {
                    this.jComboBoxGedcom.setSelectedItem(current);
                    break;
                }
                if (current.isGlobal() || selected.getGedcom() == null || current.isGlobal() || !current.getDisplayName().equals(selected.getGedcom().getDisplayName())) continue;
                this.jComboBoxGedcom.setSelectedItem(current);
                break;
            }
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        SearchNote selected = this.jListNote.getSelectedValue();
        if (selected != null) {
            this.saveNotes(selected);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        SearchNote selected = this.jListNote.getSelectedValue();
        if (selected != null) {
            int index = this.jListNote.getSelectedIndex();
            this.model.removeElement(selected);
            this.remove(selected);
            if (index > 0) {
                this.jListNote.setSelectedIndex(index - 1);
            } else if (!this.model.isEmpty()) {
                this.jListNote.setSelectedIndex(index);
            } else {
                this.jTextArea1.setText("");
            }
        }
    }

    private void jSplitPane1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dividerLocation")) {
            NbPreferences.forModule(NotePadTopComponent.class).put("NotePadSplitPane", String.valueOf(this.jSplitPane1.getDividerLocation()));
        }
    }

    private void loadNotes() {
        this.model.removeAllElements();
        for (int i = 0; i < this.jComboBoxGedcom.getItemCount(); ++i) {
            ContextElement name = (ContextElement)this.jComboBoxGedcom.getModel().getElementAt(i);
            for (SearchNote note : NotePadTopComponent.getStoredNotes(name.getContext(), name.isGlobal())) {
                this.model.addElement(note);
            }
        }
    }

    private void saveNotes(SearchNote note) {
        note.setContent(this.jTextArea1.getText());
        ContextElement ce = (ContextElement)this.jComboBoxGedcom.getModel().getSelectedItem();
        this.shouldDelete(note);
        if (ce.isGlobal()) {
            note.setGedcom(null);
        } else {
            note.setGedcom(ce.getContext());
        }
        File properties = new File(NotePadTopComponent.getFileNameFromGedcom(note.getGedcom()));
        Properties prop = new Properties();
        try {
            properties.createNewFile();
            FileInputStream in = new FileInputStream(properties);
            prop.load(in);
            this.updateProperty(prop, note);
            prop.store(new FileOutputStream(properties), "Search Notes");
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Search Notes properties error", ex);
        }
        note.setDirty(false);
        this.jListNote.repaint();
    }

    private void saveNotes() {
        SearchNote selected = this.jListNote.getSelectedValue();
        if (selected != null) {
            this.saveNotes(selected);
        }
        for (int i = 0; i < this.jComboBoxGedcom.getItemCount(); ++i) {
            ContextElement name = (ContextElement)this.jComboBoxGedcom.getModel().getElementAt(i);
            if (name.isGlobal()) continue;
            this.saveNotes(name.getContext());
        }
        ArrayList<Object> noteToSave = new ArrayList<Object>();
        for (int j = 0; j < this.model.getSize(); ++j) {
            SearchNote note = this.model.getElementAt(j);
            if (note.getGedcom() != null) continue;
            noteToSave.add(note);
        }
        if (!noteToSave.isEmpty()) {
            Properties prop = NotePadTopComponent.getProperties(null);
            for (SearchNote searchNote : noteToSave) {
                this.updateProperty(prop, searchNote);
            }
            File properties = new File(NotePadTopComponent.getFileNameFromGedcom(null));
            try {
                prop.store(new FileOutputStream(properties), "Search Notes");
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Search Notes properties error", iOException);
            }
        }
    }

    private void updateProperty(Properties prop, SearchNote note) {
        if (!note.isDirty()) {
            return;
        }
        if (prop.containsKey(note.getReference())) {
            prop.replace(note.getReference(), note.getContent());
        } else {
            prop.setProperty(note.getReference(), note.getContent());
        }
        if (prop.containsKey(note.getReference() + "_LM")) {
            prop.replace(note.getReference() + "_LM", note.getLastModified().format(SearchNote.ISO_FORMAT));
        } else {
            prop.setProperty(note.getReference() + "_LM", note.getLastModified().format(SearchNote.ISO_FORMAT));
        }
    }

    private List<SearchNote> saveNotes(Gedcom ged) {
        SearchNote selected = this.jListNote.getSelectedValue();
        if (selected != null) {
            this.saveNotes(selected);
        }
        ArrayList<SearchNote> noteToSave = new ArrayList<SearchNote>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            SearchNote note = this.model.getElementAt(i);
            if (!ged.equals(note.getGedcom())) continue;
            noteToSave.add(note);
        }
        Properties prop = NotePadTopComponent.getProperties(ged);
        for (SearchNote note : noteToSave) {
            this.updateProperty(prop, note);
        }
        File properties = new File(NotePadTopComponent.getFileNameFromGedcom(ged));
        try {
            prop.store(new FileOutputStream(properties), "Search Notes");
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Search Notes properties error", ex);
        }
        return noteToSave;
    }

    private void remove(SearchNote note) {
        Properties prop = NotePadTopComponent.getProperties(note.getGedcom());
        try {
            if (prop.containsKey(note.getReference())) {
                prop.remove(note.getReference(), note.getContent());
            }
            File properties = new File(NotePadTopComponent.getFileNameFromGedcom(note.getGedcom()));
            FileOutputStream fos = new FileOutputStream(properties);
            prop.store(fos, "Search Notes");
            fos.close();
            if (prop.isEmpty()) {
                properties.delete();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Search Notes properties error", ex);
        }
    }

    private void shouldDelete(SearchNote note) {
        Gedcom ged = note.getGedcom();
        ContextElement ce = (ContextElement)this.jComboBoxGedcom.getModel().getSelectedItem();
        if (ce.isGlobal() && ged == null) {
            return;
        }
        if (ce.isGlobal() && ged != null || !ce.getContext().equals(ged)) {
            this.remove(note);
        }
    }

    private static File getStorageDir() {
        return new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/searchnote", (String)"?", (String)"Looking for searchnote"));
    }

    private static String getFileNameFromGedcom(Gedcom gedcom) {
        File dir = NotePadTopComponent.getStorageDir();
        String fileName = gedcom != null ? dir + File.separator + gedcom.getDisplayName() + ".notes" : dir + File.separator + "none.notes";
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(Gedcom gedcom) {
        File properties = new File(NotePadTopComponent.getFileNameFromGedcom(gedcom));
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            properties.createNewFile();
            in = new FileInputStream(properties);
            prop.load(in);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Search Notes properties error", ex);
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "Search Notes properties error", e);
                }
            }
        }
        return prop;
    }

    public static List<SearchNote> getStoredNotes(Gedcom gedcom, boolean isGlobal) {
        ArrayList<SearchNote> ret = new ArrayList<SearchNote>();
        File properties = new File(NotePadTopComponent.getFileNameFromGedcom(gedcom));
        if (properties.exists()) {
            Properties prop = NotePadTopComponent.getProperties(gedcom);
            for (Map.Entry<Object, Object> property : prop.entrySet()) {
                String dateTime;
                String key = (String)property.getKey();
                if (key.endsWith("_LM")) continue;
                SearchNote note = new SearchNote(key);
                note.setContent((String)property.getValue());
                if (!isGlobal) {
                    note.setGedcom(gedcom);
                }
                if ((dateTime = prop.getProperty(key + "_LM")) == null) {
                    dateTime = key.substring("SEARCH_NOTE_".length());
                }
                note.setLastModified(LocalDateTime.parse(dateTime, SearchNote.ISO_FORMAT));
                ret.add(note);
            }
        }
        return ret;
    }

    public static synchronized NotePadTopComponent getFactory() {
        if (factory == null) {
            factory = new NotePadTopComponent();
        }
        return factory;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void open() {
        Mode mode = WindowManager.getDefault().findMode("ancestris-editor");
        if (mode != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    public int getPersistenceType() {
        return 1;
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public void commitRequested(Context context) {
        this.saveNotes(context.getGedcom());
    }

    public void gedcomOpened(Gedcom gedcom) {
        ContextElement ce = new ContextElement(gedcom.getDisplayName(), gedcom);
        Boolean already = false;
        for (int i = 0; i < this.jComboBoxGedcom.getItemCount(); ++i) {
            ContextElement current = (ContextElement)this.jComboBoxGedcom.getModel().getElementAt(i);
            if (!ce.equals(current)) continue;
            already = true;
            break;
        }
        if (!already.booleanValue()) {
            this.jComboBoxGedcom.addItem(new ContextElement(gedcom.getDisplayName(), gedcom));
        }
        this.saveNotes();
        this.loadNotes();
    }

    public void gedcomClosed(Gedcom gedcom) {
        List<SearchNote> noteToRemove = this.saveNotes(gedcom);
        ContextElement ce = new ContextElement(gedcom.getDisplayName(), gedcom);
        for (int i = 0; i < this.jComboBoxGedcom.getItemCount(); ++i) {
            ContextElement current = (ContextElement)this.jComboBoxGedcom.getModel().getElementAt(i);
            if (!ce.equals(current)) continue;
            this.jComboBoxGedcom.removeItem(current);
            break;
        }
        for (SearchNote note : noteToRemove) {
            this.model.removeElement(note);
        }
    }

    protected void componentClosed() {
        AncestrisPlugin.unregister((Object)((Object)this));
    }

    protected void componentOpened() {
        AncestrisPlugin.register((Object)((Object)this));
    }
}

