/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import ancestris.api.search.SearchCommunicator;
import ancestris.modules.views.graph.ActionFilter;
import ancestris.modules.views.graph.GraphTopComponent;
import ancestris.reports.relatives.ReportRelatives;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import org.openide.util.NbBundle;

public class ActionFilterFactory {
    private static final int DEFAULT_FILTER = 0;
    private static final int ANCESTOR_FILTER = 1;
    public static ImageIcon FILTER_RELATIVES_ICON = new ImageIcon(GraphTopComponent.class.getResource("/ancestris/modules/views/graph/resources/filter_rel.png"));
    public static ImageIcon FILTER_ANCESTORS_ICON = new ImageIcon(GraphTopComponent.class.getResource("/ancestris/modules/views/graph/resources/filter_anc.png"));
    public static ImageIcon FILTER_DESCENDANTS_ICON = new ImageIcon(GraphTopComponent.class.getResource("/ancestris/modules/views/graph/resources/filter_desc.png"));
    public static ImageIcon FILTER_SEARCH_ICON = new ImageIcon(GraphTopComponent.class.getResource("/ancestris/modules/views/graph/resources/filter_search.png"));
    public static ImageIcon FILTER_ICON_CLEAR = new ImageIcon(GraphTopComponent.class.getResource("/ancestris/modules/views/graph/resources/filter_clear.png"));
    private final GraphTopComponent graph;
    private List<ActionFilter> actionFilters;
    private List<Entity> entities;
    private int currentFilter;

    public ActionFilterFactory(GraphTopComponent graph) {
        this.graph = graph;
        this.initFilters();
        this.entities = new ArrayList<Entity>();
    }

    private void initFilters() {
        this.actionFilters = new ArrayList<ActionFilter>();
        this.currentFilter = 0;
        this.actionFilters.add(new ActionFilter(FILTER_RELATIVES_ICON, NbBundle.getMessage(this.getClass(), (String)"filter_relatives")){

            @Override
            public void run(Entity entity) {
                if (entity instanceof Indi) {
                    Indi indi = (Indi)entity;
                    ActionFilterFactory.this.entities = new ArrayList<Indi>(ActionFilterFactory.this.getRelatives(indi));
                } else if (entity instanceof Fam) {
                    Indi wife;
                    Fam fam = (Fam)entity;
                    Indi husb = fam.getHusband();
                    if (husb != null) {
                        ActionFilterFactory.this.entities = new ArrayList<Indi>(ActionFilterFactory.this.getRelatives(husb));
                    }
                    if ((wife = fam.getWife()) != null) {
                        ActionFilterFactory.this.entities.addAll(new ArrayList<Indi>(ActionFilterFactory.this.getRelatives(wife)));
                    }
                }
                ActionFilterFactory.this.applyFilter(true, this);
            }
        });
        this.actionFilters.add(new ActionFilter(FILTER_ANCESTORS_ICON, NbBundle.getMessage(this.getClass(), (String)"filter_ancestors")){

            @Override
            public void run(Entity entity) {
                if (entity instanceof Indi) {
                    Indi indi = (Indi)entity;
                    ActionFilterFactory.this.entities = new ArrayList<Indi>(ActionFilterFactory.this.getAncestors(indi));
                } else if (entity instanceof Fam) {
                    Indi wife;
                    Fam fam = (Fam)entity;
                    Indi husb = fam.getHusband();
                    if (husb != null) {
                        ActionFilterFactory.this.entities = new ArrayList<Indi>(ActionFilterFactory.this.getAncestors(husb));
                    }
                    if ((wife = fam.getWife()) != null) {
                        ActionFilterFactory.this.entities.addAll(new ArrayList<Indi>(ActionFilterFactory.this.getAncestors(wife)));
                    }
                }
                ActionFilterFactory.this.applyFilter(true, this);
            }
        });
        this.actionFilters.add(new ActionFilter(FILTER_DESCENDANTS_ICON, NbBundle.getMessage(this.getClass(), (String)"filter_descendants")){

            @Override
            public void run(Entity entity) {
                if (entity instanceof Indi) {
                    Indi indi = (Indi)entity;
                    ActionFilterFactory.this.entities = new ArrayList<Indi>(ActionFilterFactory.this.getDescendants(indi));
                } else if (entity instanceof Fam) {
                    Indi wife;
                    Fam fam = (Fam)entity;
                    Indi husb = fam.getHusband();
                    if (husb != null) {
                        ActionFilterFactory.this.entities = new ArrayList<Indi>(ActionFilterFactory.this.getDescendants(husb));
                    }
                    if ((wife = fam.getWife()) != null) {
                        ActionFilterFactory.this.entities.addAll(new ArrayList<Indi>(ActionFilterFactory.this.getDescendants(wife)));
                    }
                }
                ActionFilterFactory.this.applyFilter(true, this);
            }
        });
        this.actionFilters.add(new ActionFilter(FILTER_SEARCH_ICON, NbBundle.getMessage(this.getClass(), (String)"filter_search")){

            @Override
            public void run(Entity entity) {
                ActionFilterFactory.this.entities = SearchCommunicator.getResultEntities((Gedcom)this.getGedcom());
                ActionFilterFactory.this.applyFilter(true, this);
            }
        });
        this.actionFilters.add(new ActionFilter(FILTER_ICON_CLEAR, NbBundle.getMessage(this.getClass(), (String)"filter_clear")){

            @Override
            public void run(Entity entity) {
                ActionFilterFactory.this.entities.clear();
                ActionFilterFactory.this.applyFilter(false, this);
            }
        });
    }

    public ImageIcon getIcon() {
        return FILTER_ICON_CLEAR;
    }

    public ActionFilter[] getFilters() {
        return (ActionFilter[])this.actionFilters.toArray(ActionFilter[]::new);
    }

    public void setDefaultFilter() {
        this.currentFilter = 0;
        this.getCurrentFilter().actionPerformedImpl(null);
    }

    public ActionFilter getCurrentFilter() {
        return this.getFilters()[this.currentFilter];
    }

    public List<Entity> getFilteredEntities() {
        return this.entities;
    }

    private void applyFilter(boolean set, ActionFilter action) {
        this.currentFilter = this.actionFilters.indexOf((Object)action);
        this.graph.setFilter(set, (ImageIcon)action.getImage());
        this.graph.displayFilteredNodes();
    }

    public void setAncestorFilter() {
        this.currentFilter = 1;
        this.getCurrentFilter().actionPerformedImpl(null);
    }

    private HashSet<Indi> getRelatives(Indi rootIndi) {
        HashSet<Indi> retList = new HashSet<Indi>();
        retList.addAll(new ReportRelatives().getRelatives(rootIndi));
        return retList;
    }

    private HashSet<Indi> getAncestors(Indi rootIndi) {
        if (rootIndi == null) {
            return null;
        }
        HashSet<Indi> retList = new HashSet<Indi>();
        ArrayList<Indi> indis = new ArrayList<Indi>();
        indis.add(rootIndi);
        ListIterator<Indi> it = indis.listIterator();
        while (it.hasNext()) {
            Indi indi = (Indi)it.next();
            if (retList.contains(indi)) continue;
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                Indi father;
                Indi mother = famc.getWife();
                if (mother != null) {
                    it.add(mother);
                    it.previous();
                }
                if ((father = famc.getHusband()) != null) {
                    it.add(father);
                    it.previous();
                }
            }
            retList.add(indi);
        }
        return retList;
    }

    private HashSet<Indi> getDescendants(Indi rootIndi) {
        if (rootIndi == null) {
            return null;
        }
        HashSet<Indi> retList = new HashSet<Indi>();
        ArrayList<Indi> indis = new ArrayList<Indi>();
        indis.add(rootIndi);
        ListIterator<Indi> it = indis.listIterator();
        while (it.hasNext()) {
            Indi[] children;
            Indi indi = (Indi)it.next();
            if (retList.contains(indi)) continue;
            for (Indi kid : children = indi.getChildren()) {
                it.add(kid);
                it.previous();
            }
            retList.add(indi);
        }
        return retList;
    }
}

