/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.utils;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyNote;
import java.text.Collator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PropUtils {
    public static String getPropertyValue(Property property) {
        return property == null ? "" : property.getValue();
    }

    public static String getAgeValue(Property age, boolean yearsOnly) {
        if (age == null) {
            return "";
        }
        if (age instanceof PropertyAge) {
            PropertyAge pAge = (PropertyAge)age;
            if (yearsOnly) {
                return String.valueOf(pAge.getAge().getYears());
            }
            return pAge.getReportValue();
        }
        return "";
    }

    public static String getFirstNameValue(Property name, boolean firstOnly) {
        if (name == null) {
            return "";
        }
        if (name instanceof PropertyName) {
            PropertyName pName = (PropertyName)name;
            if (firstOnly) {
                return pName.getFirstName().split(" ")[0];
            }
            return pName.getFirstName();
        }
        return "";
    }

    public static String getIndiValue(Indi indi, boolean id) {
        if (indi == null) {
            return "";
        }
        return indi.getName() + (String)(id ? " " + PropUtils.getIdValue((Entity)indi) : "");
    }

    public static String getIdValue(Entity entity) {
        return entity == null ? "" : "(" + entity.getId() + ")";
    }

    public static Collection<String> getEventNames() {
        return PropUtils.getTag2NameMap().values();
    }

    public static String[] getEventNames(String[] tags) {
        String[] names = new String[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            names[i] = Gedcom.getName((String)tags[i]);
        }
        return names;
    }

    public static Map<String, String> getTag2NameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String tag : GedcomConstants.TAG_YES_EVENTS) {
            map.put(tag, Gedcom.getName((String)tag));
        }
        for (String tag : (Set)GedcomConstants.TAG_ATTR_EVENTS_MAP.get(Grammar.V70)) {
            map.put(tag, Gedcom.getName((String)tag));
        }
        Map sortedMap = map.entrySet().stream().sorted(Map.Entry.comparingByValue(Collator.getInstance(Locale.getDefault()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return sortedMap;
    }

    public static String getEventTags(int[] indices) {
        Map<String, String> map = PropUtils.getTag2NameMap();
        String[] tags = (String[])map.keySet().toArray(String[]::new);
        return PropUtils.getEventTags(indices, tags);
    }

    public static String getEventTags(int[] indices, String[] tags) {
        StringBuilder sb = new StringBuilder();
        for (int i : indices) {
            sb.append(tags[i]);
            sb.append("|");
        }
        return sb.toString().replaceAll("\\|$", "");
    }

    public static String getStringFromIndi(Indi indi) {
        String nick;
        PropertyName nameP;
        String[] firstnames;
        String[] names;
        Object ret = "";
        for (String name : names = indi.getLastNames()) {
            ret = (String)ret + name + " ";
        }
        for (String firstname : firstnames = indi.getFirstNames()) {
            ret = (String)ret + firstname + " ";
        }
        ret = (String)ret + indi.toString(true);
        String sosaStr = indi.getSosaString();
        if (!sosaStr.isEmpty()) {
            ret = (String)ret + " [" + sosaStr + "]";
        }
        if ((nameP = indi.getNameProperty()) instanceof PropertyName && !(nick = nameP.getNick()).isEmpty()) {
            ret = (String)ret + " " + nick;
        }
        List properties = indi.getAllProperties("NOTE");
        for (Property noteProp : properties) {
            String text;
            if (noteProp == null || noteProp instanceof PropertyNote || (text = noteProp.getDisplayValue().replaceAll("(\\r|\\n)", "").trim()).isEmpty()) continue;
            ret = (String)ret + " " + text;
        }
        return ((String)ret).toLowerCase();
    }

    public static String getStringFromFam(Fam fam) {
        Indi wife;
        Object ret = "";
        Indi husb = fam.getHusband();
        if (husb != null) {
            String[] names;
            for (String name : names = husb.getLastNames()) {
                ret = (String)ret + name + " ";
            }
            String[] firstnames = husb.getFirstNames();
            for (String firstname : firstnames) {
                ret = (String)ret + (String)firstname + " ";
            }
        }
        if ((wife = fam.getWife()) != null) {
            String[] firstnames;
            String[] names = wife.getLastNames();
            for (String name : names) {
                ret = (String)ret + (String)name + " ";
            }
            for (String firstname : firstnames = wife.getFirstNames()) {
                ret = (String)ret + firstname + " ";
            }
        }
        List properties = fam.getAllProperties("NOTE");
        for (Property noteProp : properties) {
            String text;
            if (noteProp == null || noteProp instanceof PropertyNote || (text = noteProp.getDisplayValue().replaceAll("(\\r|\\n)", "").trim()).isEmpty()) continue;
            ret = (String)ret + " " + text;
        }
        ret = (String)ret + fam.toString(true);
        return ((String)ret).toLowerCase();
    }
}

