/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer.empty;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class EmptyTileFactory
extends TileFactory {
    private BufferedImage emptyTile;

    public EmptyTileFactory() {
        this(new TileFactoryInfo("EmptyTileFactory 256x256", 1, 15, 17, 256, true, true, "", "x", "y", "z"));
    }

    public EmptyTileFactory(TileFactoryInfo info) {
        super(info);
        int tileSize = info.getTileSize(info.getMinimumZoomLevel());
        this.emptyTile = new BufferedImage(tileSize, tileSize, 2);
        Graphics2D g = this.emptyTile.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, tileSize, tileSize);
        g.setColor(Color.WHITE);
        g.drawOval(10, 10, tileSize - 20, tileSize - 20);
        g.fillOval(70, 50, 20, 20);
        g.fillOval(tileSize - 90, 50, 20, 20);
        g.fillOval(tileSize / 2 - 10, tileSize / 2 - 10, 20, 20);
        g.dispose();
    }

    public Tile getTile(int x, int y, int zoom) {
        return new Tile(x, y, zoom){

            public boolean isLoaded() {
                return true;
            }

            public BufferedImage getImage() {
                return EmptyTileFactory.this.emptyTile;
            }
        };
    }

    protected void startLoading(Tile tile) {
    }
}

