/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import ancestris.util.TimingUtility;
import genj.util.ChangeSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeListener;

public class FontChooser
extends JPanel {
    private JComboBox fonts;
    private static String[] fontNames = null;
    private Runnable callback = null;
    private JTextField size;
    private ChangeSupport changes = new ChangeSupport(this);
    private boolean isRenderWithFont = false;

    public FontChooser() {
        this.fonts = new JComboBox();
        this.getAllFonts();
        this.fonts.setEditable(false);
        this.fonts.setRenderer(new Renderer());
        this.size = new JTextField(3);
        this.size.getDocument().addDocumentListener(this.changes);
        this.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fonts, "Center");
        this.add((Component)this.size, "East");
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension result = super.getPreferredSize();
        result.width = Integer.MAX_VALUE;
        return result;
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            this.fonts.setSelectedIndex(-1);
            this.size.setText("");
            return;
        }
        for (int i = 0; i < this.fonts.getItemCount(); ++i) {
            Font f = (Font)this.fonts.getItemAt(i);
            if (!f.getName().equals(font.getName())) continue;
            this.fonts.setSelectedIndex(i);
            break;
        }
        this.size.setText("" + font.getSize());
    }

    public Font getSelectedFont() {
        Font font = (Font)this.fonts.getSelectedItem();
        if (font == null) {
            return null;
        }
        return font.deriveFont((float)this.getSelectedFontSize());
    }

    private int getSelectedFontSize() {
        int result = 10;
        try {
            result = Integer.parseInt(this.size.getText());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Math.max(2, result);
    }

    private void getAllFonts() {
        TimingUtility.getInstance().reset();
        SwingWorker aWorker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                if (fontNames == null) {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    fontNames = env.getAvailableFontFamilyNames();
                }
                for (String fontName : fontNames) {
                    Font f = new Font(fontName, 0, 12);
                    if (!f.canDisplay('A') || !f.canDisplay(' ')) continue;
                    FontChooser.this.fonts.addItem(f);
                }
                return null;
            }

            @Override
            protected void done() {
                if (FontChooser.this.callback != null) {
                    FontChooser.this.callback.run();
                }
                FontChooser.this.fonts.addActionListener(FontChooser.this.changes);
            }
        };
        SwingUtilities.invokeLater(aWorker);
    }

    public void setCallBack(Runnable runnable) {
        this.callback = runnable;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changes.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changes.removeChangeListener(listener);
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Font) {
                Font font = (Font)value;
                super.getListCellRendererComponent((JList<?>)list, font.getFamily(), index, isSelected, cellHasFocus);
                if (FontChooser.this.isRenderWithFont) {
                    this.setFont(font);
                }
            } else {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            return this;
        }
    }
}

