/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class PopupWidget
extends JButton {
    private long fireOnClickWithin = 0L;
    private JPopupMenu popup;

    public PopupWidget() {
        this((Icon)null);
    }

    public PopupWidget(Icon icon) {
        this(null, icon);
    }

    public PopupWidget(String text) {
        this(text, null);
    }

    public PopupWidget(String text, Icon icon) {
        super(text, icon);
        this.setModel(new Model());
        this.setFocusable(false);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.popup = new JPopupMenu();
    }

    public void cancelPopup() {
        this.popup.setVisible(false);
    }

    protected void setPopupSize(Dimension d) {
        Container c;
        Dimension min = ((Component)c).getMinimumSize();
        d.width = Math.max(min.width, d.width);
        d.height = Math.max(min.height, d.height);
        Dimension old = c.getSize();
        for (c = this.getPopup(); c != null && c.getSize().equals(old); c = c.getParent()) {
            c.setSize(d);
        }
        this.getPopup().revalidate();
    }

    public void showPopup() {
        this.cancelPopup();
        this.popup = this.getPopup();
        if (this.popup == null) {
            return;
        }
        int x = 0;
        int y = 0;
        if (!JToolBar.class.isAssignableFrom(this.getParent().getClass())) {
            x += this.getWidth();
        } else {
            JToolBar bar = (JToolBar)this.getParent();
            if (1 == bar.getOrientation()) {
                x += bar.getLocation().x == 0 ? this.getWidth() : -this.popup.getPreferredSize().width;
            } else {
                y += bar.getLocation().y < this.getHeight() ? this.getHeight() : -this.popup.getPreferredSize().height;
            }
        }
        this.popup.show(this, x, y);
    }

    protected JPopupMenu getPopup() {
        return this.popup;
    }

    public void addItem(Component c) {
        this.popup.add(c);
    }

    public void addItems(List<? extends Action> actions) {
        for (Action action : actions) {
            this.addItem(action);
        }
    }

    public void addItem(Action action) {
        this.popup.add(new JMenuItem(action));
    }

    public void removeItems() {
        this.popup.removeAll();
    }

    public void addSeparator() {
        this.popup.addSeparator();
    }

    public void setFireOnClickWithin(long ms) {
        this.fireOnClickWithin = ms;
    }

    private class Model
    extends DefaultButtonModel
    implements Runnable {
        private long triggerTime = 0L;

        private Model() {
        }

        @Override
        public void setPressed(boolean b) {
            super.setPressed(b);
            if (b) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            PopupWidget.this.showPopup();
            this.triggerTime = System.currentTimeMillis();
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (PopupWidget.this.fireOnClickWithin > 0L && System.currentTimeMillis() - this.triggerTime < PopupWidget.this.fireOnClickWithin) {
                for (int i = 0; i < PopupWidget.this.popup.getComponentCount(); ++i) {
                    Component c = PopupWidget.this.popup.getComponent(i);
                    if (!(c instanceof AbstractButton)) continue;
                    PopupWidget.this.cancelPopup();
                    ((AbstractButton)c).doClick();
                    break;
                }
            }
        }
    }
}

