/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text.parser.rules;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.utils.CommonUtils;

public class NumberRule
implements TPRule {
    public static final int RADIX_DECIMAL = 10;
    public static final int RADIX_HEXADECIMAL = 16;
    protected TPToken fToken;

    public NumberRule(@NotNull TPToken token) {
        this.fToken = token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int ch = scanner.read();
        int chCount = 1;
        if (!Character.isDigit(ch)) {
            return NumberRule.undefined(scanner, 1);
        }
        boolean seenDecimalSeparator = false;
        boolean seenScientificNotation = false;
        int radix = 10;
        if (ch == 48) {
            int ch1 = scanner.read();
            if (ch1 == 120 || ch1 == 88) {
                ch1 = scanner.read();
                if (!CommonUtils.isDigit((int)ch1, (int)16)) return NumberRule.undefined(scanner, 3);
                radix = 16;
            } else {
                scanner.unread();
            }
        }
        while (true) {
            if (radix == 10 && ch == 46) {
                if (seenDecimalSeparator) {
                    return NumberRule.undefined(scanner, chCount);
                }
                ch = scanner.read();
                ++chCount;
                if (ch < 48 || ch > 57) {
                    return NumberRule.undefined(scanner, chCount);
                }
                seenDecimalSeparator = true;
                continue;
            }
            if (radix == 10 && (ch == 101 || ch == 69)) {
                if (seenScientificNotation) {
                    return NumberRule.undefined(scanner, chCount);
                }
                ch = scanner.read();
                ++chCount;
                if (ch == 43 || ch == 45) {
                    ch = scanner.read();
                    ++chCount;
                }
                if (ch < 48 || ch > 57) {
                    return NumberRule.undefined(scanner, chCount);
                }
                seenScientificNotation = true;
                continue;
            }
            if (!CommonUtils.isDigit((int)ch, (int)radix)) {
                scanner.unread();
                return this.fToken;
            }
            ch = scanner.read();
            ++chCount;
        }
    }

    private static TPToken undefined(TPCharacterScanner scanner, int readCount) {
        while (readCount > 0) {
            --readCount;
            scanner.unread();
        }
        return TPTokenAbstract.UNDEFINED;
    }
}

