/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.maven.MavenArtifact;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.registry.maven.MavenArtifactVersion;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class MavenRepository {
    private static final Log log = Log.getLog(MavenRepository.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.mavenRepository";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    private String id;
    private final RepositoryType type;
    private String name;
    private String url;
    private final List<String> scopes = new ArrayList<String>();
    private int order;
    private boolean enabled = true;
    private String description;
    private final DBPAuthInfo authInfo = new DBPAuthInfo();
    private Map<String, MavenArtifact> cachedArtifacts = new LinkedHashMap<String, MavenArtifact>();

    public MavenRepository(IConfigurationElement config) {
        this.id = config.getAttribute(ATTR_ID);
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        this.name = CommonUtils.toString((Object)config.getAttribute(ATTR_NAME), (String)this.id);
        String urlString = config.getAttribute("url");
        if (!urlString.endsWith("/")) {
            urlString = String.valueOf(urlString) + "/";
        }
        this.url = urlString;
        this.type = RepositoryType.GLOBAL;
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("scope");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement scope = iConfigurationElementArray[n2];
            String group = scope.getAttribute("group");
            if (!CommonUtils.isEmpty((String)group)) {
                this.scopes.add(group);
            }
            ++n2;
        }
    }

    public MavenRepository(String id, String name, String url, RepositoryType type) {
        this.id = id;
        this.type = type;
        String string = this.name = CommonUtils.isEmpty((String)name) ? id : name;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        this.url = url;
    }

    public MavenRepository(MavenRepository source) {
        this.id = source.id;
        this.type = source.type;
        this.name = source.name;
        this.url = source.url;
        this.scopes.addAll(source.scopes);
        this.order = source.order;
        this.enabled = source.enabled;
        this.description = source.description;
        this.authInfo.setUserName(source.authInfo.getUserName());
        this.authInfo.setUserPassword(source.authInfo.getUserPassword());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @NotNull
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes.clear();
        this.scopes.addAll(scopes);
    }

    public RepositoryType getType() {
        return this.type;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public DBPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public boolean isSecureRepository() {
        if (this.type == RepositoryType.LOCAL || this.type == RepositoryType.CUSTOM) {
            return true;
        }
        return this.url.startsWith("https");
    }

    @Nullable
    public synchronized MavenArtifactVersion findArtifact(DBRProgressMonitor monitor, @NotNull MavenArtifactReference ref) {
        boolean newArtifact = false;
        MavenArtifact artifact = this.cachedArtifacts.get(ref.getId());
        if (artifact == null) {
            artifact = new MavenArtifact(this, ref.getGroupId(), ref.getArtifactId(), ref.getClassifier());
            newArtifact = true;
        }
        try {
            MavenArtifactVersion version = artifact.resolveVersion(monitor, ref.getVersion());
            if (newArtifact) {
                this.cachedArtifacts.put(ref.getId(), artifact);
            }
            return version;
        }
        catch (IOException e) {
            log.debug((Object)("Maven artifact '" + ref + "' not found in repository '" + this + "': " + e.getMessage()));
            return null;
        }
    }

    synchronized void resetArtifactCache(@NotNull MavenArtifactReference artifactReference) {
        this.cachedArtifacts.remove(artifactReference.getId());
    }

    File getLocalCacheDir() {
        String extPath;
        switch (this.type) {
            case EXTERNAL: {
                try {
                    URL repoUrl = new URL(this.url);
                    extPath = ".external/" + repoUrl.getHost() + "/" + repoUrl.getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    extPath = ".external/" + this.id;
                }
                break;
            }
            default: {
                extPath = this.id;
            }
        }
        File homeFolder = new File(DBWorkbench.getPlatform().getCustomDriversHome(), "maven/" + extPath);
        if (!homeFolder.exists() && !homeFolder.mkdirs()) {
            log.warn((Object)("Can't create maven repository '" + this.name + "' cache folder '" + homeFolder + "'"));
        }
        return homeFolder;
    }

    public String toString() {
        return this.url;
    }

    public static enum RepositoryType {
        GLOBAL,
        LOCAL,
        CUSTOM,
        EXTERNAL;

    }
}

