/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2ViewBase;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2ViewCheck;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2View
extends DB2ViewBase
implements DB2SourceObject {
    private DB2ViewCheck viewCheck;
    private Boolean readOnly;

    public DB2View(DBRProgressMonitor monitor, DB2Schema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
        this.viewCheck = (DB2ViewCheck)CommonUtils.valueOf(DB2ViewCheck.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VIEWCHECK"));
        this.readOnly = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"READONLY", (String)DB2YesNo.Y.name());
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        return ((DB2Schema)this.getContainer()).getViewCache().refreshObject(monitor, (DB2Schema)this.getContainer(), this);
    }

    public JDBCStructCache<DB2Schema, DB2View, DB2TableColumn> getCache() {
        return ((DB2Schema)this.getContainer()).getViewCache();
    }

    @Property(viewable=true, editable=false, order=21)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Property(viewable=true, editable=false, order=22)
    public DB2ViewCheck getViewCheck() {
        return this.viewCheck;
    }

    @Override
    @Property(hidden=true)
    public Integer getTableId() {
        return super.getTableId();
    }
}

