﻿/***************************************************************
 * Name:      eventdialog.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2013
 * License:   GPL3
 **************************************************************/

#ifndef EVENTDIALOG_H
#define EVENTDIALOG_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/datectrl.h>
#include <wx/spinctrl.h>
#include <wx/timectrl.h>
#include "data/engine.h"
#include "widgets/dxcalendarpickerctrl.h"
#include "widgets/dxtimepickerctrl.h"

class ReminderDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(ReminderDialog)
public:
    ReminderDialog() {}
    ReminderDialog(wxWindow *parent, wxInt64 reminder);

    wxInt64 reminder();
private:
    wxSpinCtrl *m_days, *m_hours, *m_mins;
};

class RecurrenceDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(RecurrenceDialog)
public:
    RecurrenceDialog() {}
    RecurrenceDialog(wxWindow *parent, int days, int months, int hours, int minutes);

    int days();
    int months();
    int hours();
    int minutes();
private:
    wxSpinCtrl *m_days, *m_moths;
    wxSpinCtrl *m_hours, *m_minutes;
};

class RecurrenceMontlyDayDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(RecurrenceMontlyDayDialog)
public:
    RecurrenceMontlyDayDialog() {}
    RecurrenceMontlyDayDialog(wxWindow *parent, int mday, int mweek);

    int day();
    int week();
private:
    wxSpinCtrl *m_mweek;
    wxChoice *m_mday;
};

class EventDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(EventDialog)
    DECLARE_EVENT_TABLE()
public:
    EventDialog() : m_editing(false) {}
    EventDialog(wxWindow *parent);
    EventDialog(wxWindow *parent, const wxDateTime &date);
    EventDialog(wxWindow *parent, Event event);

    void OnOk(wxCommandEvent& event);
    void OnCancel(wxCommandEvent& event);
private:
    bool m_editing;
    wxInt64 m_id;
    wxTextCtrl *m_eventCtrl;
    wxTextCtrl*m_descriptionCtrl;
    wxStaticText *m_timeText;
    dxTimePickerCtrl *m_timeCtrl;
    wxStaticText *m_dateText;
    dxCalendarPickerCtrl *m_dateCtrl;
    wxStaticText *m_reminderText;
    wxChoice *m_reminderCtrl, *m_recurrenceCtrl;
    wxInt64 m_reminder;
    wxInt64 m_reminderOwn;
    wxBoxSizer *m_mainSizer;
    int m_type, m_days, m_months;
    int m_daysOwn, m_monthsOwn;
    wxBitmapButton *m_reminderEdit;
    wxBitmapButton *m_recurrenceEdit;
    int m_mday, m_mweek;
    int m_minutes, m_hours;
    int m_minutesOwn, m_hoursOwn;
    wxDateTime m_until;
    wxStaticText *m_untilText;
    wxChoice *m_untilChoice;
    wxBitmapButton *m_untilEdit;
    wxCheckBox *m_hideEvent;
    wxStaticText *m_alwaysText;
    wxCheckBox *m_always;

    void createControls();
    void fillControls(Event event);
    void OnReminder(wxCommandEvent& event);
    void OnRecurrence(wxCommandEvent& event);
    void OnKeyUp(wxKeyEvent& event);
    wxDateTime createDateTime();
    wxDateTime untilDate();
    wxDateTime roundTime();
    void OnReminderEdit(wxCommandEvent& event);
    void OnRecurrenceEdit(wxCommandEvent& event);
    void recurrenceText();
    wxString ownRecurrenceText();
    void OnUntil(wxCommandEvent& event);
    void OnUntilEdit(wxCommandEvent& event);
    void OnDescriptionChanged(wxCommandEvent& event);
};

#endif  /* EVENTDIALOG_H */

