/***************************************************************
 * Name:      dxtimepickerctrl.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef DXTIMEPICKERCTRL_H
#define DXTIMEPICKERCTRL_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/spinctrl.h>

class TimeDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(TimeDialog)
public:
    TimeDialog() {}
    TimeDialog(wxWindow *parent, const wxDateTime &time);

    wxDateTime time() const;
private:
    wxSpinCtrl *m_hours;
    wxSpinCtrl *m_minutes;
    wxStaticText *m_AMPM;
    wxSpinButton *m_AMPMSpin;
    wxDateTime m_time;

    void OnSpinCtrl(wxSpinEvent &event);
    void OnSpinUp(wxSpinEvent &event);
    void OnSpinDown(wxSpinEvent &event);
    void changeHours();
};

class dxTimePickerCtrl: public wxPanel
{
    DECLARE_EVENT_TABLE()
public:
    dxTimePickerCtrl(wxWindow *parent, const wxDateTime &time);

    wxDateTime time() const;
    void setTime(const wxDateTime &time);
    bool Enable(bool enable = true);
private:
    wxBoxSizer *m_mainSizer;
    wxStaticText *m_text;
    wxBitmapButton *m_select;
    wxDateTime m_time;

    void OnSelect(wxCommandEvent &event);
};

#endif  /* DXTIMEPICKERCTRL_H */

