/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceHeaderPainter;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new SubstanceToolBarSeparatorUI();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceTitlePainter titlePainter = SubstanceCoreUtilities.getTitlePainter(SwingUtilities.getRootPane(c));
        boolean shouldUseHeaderPainter = titlePainter instanceof SubstanceHeaderPainter;
        if (titlePainter instanceof SubstanceHeaderPainter) {
            shouldUseHeaderPainter = ((SubstanceHeaderPainter)titlePainter).isPaintingToolbars();
        }
        SubstanceTheme theme = shouldUseHeaderPainter ? SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme() : SubstanceLookAndFeel.getTheme();
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme.getActiveTheme());
        ColorScheme colorScheme = shouldUseHeaderPainter || isDark ? theme.getActiveTheme().getColorScheme() : theme.getDefaultTheme().getColorScheme();
        SubstanceCoreUtilities.paintSeparator(graphics, colorScheme, isDark, c.getWidth(), c.getHeight(), ((JSeparator)c).getOrientation());
        graphics.dispose();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension size = ((JToolBar.Separator)c).getSeparatorSize();
        if (size != null) {
            size = size.getSize();
        } else {
            size = new Dimension(6, 6);
            if (((JSeparator)c).getOrientation() == 1) {
                size.height = 0;
            } else {
                size.width = 0;
            }
        }
        return size;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension pref = this.getPreferredSize(c);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(pref.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, pref.height);
    }
}

