#!/bin/bash

# MX Linux pkexec wrapper to retain QT environment
# Usage:
#        mx-pkexec mx-apps ...
# original code by fehlix for MX-Linux
# fehlix 29.06.2018
# mx-edit-as-root.sh

if [ "$EUID" != 0 ]; then
    # normal user
    # wayland fix (chkboom)
    if [ x"$WAYLAND_DISPLAY" != "x" ] && [ -n "${WAYLAND_DISPLAY##/*}" ]; then
       WAYLAND_DISPLAY=$XDG_RUNTIME_DIR/$WAYLAND_DISPLAY
    fi
# opens user's mime-default text-editor as root
# option -e <EDITOR> : overrides default

P=$(readlink -f $0 ) # PROG

## for option -e 
unset E
while getopts "e:" opt; do
	case $opt in
		e)  E=$OPTARG   ;; #  EDITOR
	esac
done
shift $((OPTIND-1))
# do we have default editor 
[ -z "$E" ] && { 
	MIME_DEFAULT=$(xdg-mime query default text/plain)
	E=$(sed -nE '/^Exec=/{s/Exec=//;s/\s+.*//;p;q}' 2>&- {/home/$USER/.local,/usr{/local,}}/share/applications/${MIME_DEFAULT}) 
    echo $E
}

EDITOR=$(command -v "$E") || exit
echo $EDITOR

##launch editor
    pkexec /usr/bin/mx-edit-as-root.sh "$EDITOR $@"

else
    # root user
    # XDG_RUNTIME_DIR - create a valid runtime dir in case it's missing
    if [ "$XDG_RUNTIME_DIR" != "/run/user/0" ]; then
      XDG_RUNTIME_DIR=/run/user/0
      export XDG_RUNTIME_DIR
      [ -d $XDG_RUNTIME_DIR ] || mkdir -p $XDG_RUNTIME_DIR
      chmod 700 $XDG_RUNTIME_DIR
      chown 0:0 $XDG_RUNTIME_DIR
    fi
    # add /usr/local/bin as first entry into PATH if not already
    [ -z "${PATH##/usr/local/bin:*}" ] || PATH="/usr/local/bin:$PATH"

    # put pattern list of environment variables we want get 
    # from users environment into an array
    __ENVIRONEMENT_PATTERN__=(
    DESKTOP_SESSION=
    KDE_FULL_SESSION=
    LANG=
    LANGUAGE=
    LC_[[:alpha:]]+=
    PWD=
    QT_[[:alnum:]_]+=
    XDG_CURRENT_DESKTOP=
    XDG_SESSION_TYPE=
    WAYLAND_DISPLAY=
    )
    # combine array into a string of space separated entries 
    __ENVIRONEMENT_PATTERN__="${__ENVIRONEMENT_PATTERN__[*]}"
    # replace spaces with pipe-symbole as pattern alternative
    __ENVIRONEMENT_PATTERN__="^(${__ENVIRONEMENT_PATTERN__// /|})"
    # read environment variables from users process environement table
    while read -r; do  
        IFS='=' read -r  k v  <<<"$REPLY" 
        # remove any 'bad' special char's like back-quotes and dollar sign
        v="${v//[\`\$]/}"
        # change to user working dir
        [ "$k" = "PWD" ] && cd "$v" && continue
        # echo export $k="${v@Q}"  
        export $k="$v"  
    done < <( xargs -0 -L1 -a /proc/$PPID/environ \
            | grep -E "${__ENVIRONEMENT_PATTERN__}")

    unset k v
    unset __ENVIRONEMENT_PATTERN__

    # check if command is given within one parameter, split by eval in case
    [ $# == 1 ] && eval set "$@"
    RUN="$1"
    shift
    
    # check remaining parameter are quoted twice and do unquote
    [ $# != 0 ] && [ -z "${1##[\'\"]*}" ] && [ -z "${1%%*[\'\"]}" ] && eval set "$@"
    echo Starting "$RUN" "${@@Q}"
    command -v "$RUN" >/dev/null || { echo "mx-pkexec: Command '$RUN' not found"; exit 1; }
    exec "$RUN" "${@}"
fi
exit

