/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import javax.inject.Inject;
import jnr.ffi.Pointer;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.PerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.struct.FileStat;

@PerAdapter
class ReadOnlyLinkHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyLinkHandler.class);
    private final FileAttributesUtil attrUtil;
    private final FileNameTranscoder fileNameTranscoder;

    @Inject
    public ReadOnlyLinkHandler(FileAttributesUtil attrUtil, FileNameTranscoder fileNameTranscoder) {
        this.attrUtil = attrUtil;
        this.fileNameTranscoder = fileNameTranscoder;
    }

    public int getattr(Path path, BasicFileAttributes attrs, FileStat stat) {
        if (attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            long mode = this.attrUtil.posixPermissionsToOctalMode(posixAttrs.permissions());
            stat.st_mode.set((Number)(0xA000L | (mode &= 0x16DL)));
        } else {
            stat.st_mode.set((Number)41325);
        }
        this.attrUtil.copyBasicFileAttributesFromNioToFuse(attrs, stat);
        return 0;
    }

    public int readlink(Path path, Pointer buf, long size) throws IOException {
        Path target = Files.readSymbolicLink(path);
        ByteBuffer fuseEncodedTarget = this.fileNameTranscoder.interpretAsFuseString(this.fileNameTranscoder.nioToFuse(target.toString()));
        int len = (int)Math.min((long)fuseEncodedTarget.remaining(), size - 1L);
        assert ((long)len < size);
        buf.put(0L, fuseEncodedTarget.array(), 0, len);
        buf.putByte((long)len, (byte)0);
        return 0;
    }
}

