/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.cryptomator.frontend.fuse.AdapterFactory;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.mount.EnvironmentVariables;
import org.cryptomator.frontend.fuse.mount.FuseMountException;
import org.cryptomator.frontend.fuse.mount.Mount;
import org.cryptomator.frontend.fuse.mount.Mounter;

public abstract class AbstractMounter
implements Mounter {
    private static final int MOUNT_TIMEOUT_MILLIS = Integer.getInteger("org.cryptomator.frontend.fuse.mountTimeOut", 10000);
    private static final AtomicInteger MOUNT_COUNTER = new AtomicInteger(0);

    @Override
    public synchronized Mount mount(Path directory, EnvironmentVariables envVars, Consumer<Throwable> onFuseExit, boolean debug) throws FuseMountException {
        AtomicReference exception = new AtomicReference();
        FuseNioAdapter fuseAdapter = AdapterFactory.createReadWriteAdapter(directory, 254, envVars.getFileNameTranscoder());
        Thread mountThread = new Thread(() -> {
            try {
                fuseAdapter.mount(envVars.getMountPoint(), true, debug, envVars.getFuseFlags());
            }
            catch (Exception e) {
                exception.set(e);
            }
            finally {
                onFuseExit.accept((Throwable)exception.get());
            }
        });
        mountThread.setName("fuseMount-" + MOUNT_COUNTER.getAndIncrement() + "-main");
        mountThread.setDaemon(true);
        mountThread.start();
        try {
            fuseAdapter.awaitInitCall(MOUNT_TIMEOUT_MILLIS);
            return this.createMountObject(fuseAdapter, envVars);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FuseMountException("Mounting operation interrupted.");
        }
        catch (TimeoutException e) {
            if (exception.get() != null) {
                throw new FuseMountException((Throwable)exception.get());
            }
            throw new FuseMountException(e);
        }
    }

    @Override
    public abstract String[] defaultMountFlags();

    @Override
    public abstract boolean isApplicable();

    protected abstract Mount createMountObject(FuseNioAdapter var1, EnvironmentVariables var2);
}

