/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.api.FileHeaderCryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.v1.FileHeaderImpl;

class FileHeaderCryptorImpl
implements FileHeaderCryptor {
    private final Masterkey masterkey;
    private final SecureRandom random;

    FileHeaderCryptorImpl(Masterkey masterkey, SecureRandom random) {
        this.masterkey = masterkey;
        this.random = random;
    }

    @Override
    public FileHeader create() {
        byte[] nonce = new byte[16];
        this.random.nextBytes(nonce);
        byte[] contentKey = new byte[32];
        this.random.nextBytes(contentKey);
        FileHeaderImpl.Payload payload = new FileHeaderImpl.Payload(-1L, contentKey);
        return new FileHeaderImpl(nonce, payload);
    }

    @Override
    public int headerSize() {
        return 88;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ByteBuffer encryptHeader(FileHeader header) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public FileHeader decryptHeader(ByteBuffer ciphertextHeaderBuf) throws AuthenticationFailedException {
        if (ciphertextHeaderBuf.remaining() < 88) {
            throw new IllegalArgumentException("Malformed ciphertext header");
        }
        ByteBuffer buf = ciphertextHeaderBuf.asReadOnlyBuffer();
        byte[] nonce = new byte[16];
        buf.position(0);
        buf.get(nonce);
        byte[] ciphertextPayload = new byte[40];
        buf.position(16);
        buf.get(ciphertextPayload);
        byte[] expectedMac = new byte[32];
        buf.position(56);
        buf.get(expectedMac);
        try (DestroyableSecretKey mk = this.masterkey.getMacKey();){
            ByteBuffer nonceAndCiphertextBuf = buf.duplicate();
            nonceAndCiphertextBuf.position(0).limit(56);
            Mac mac = MacSupplier.HMAC_SHA256.withKey(mk);
            mac.update(nonceAndCiphertextBuf);
            byte[] calculatedMac = mac.doFinal();
            if (!MessageDigest.isEqual(expectedMac, calculatedMac)) {
                throw new AuthenticationFailedException("Header MAC doesn't match.");
            }
        }
        ByteBuffer payloadCleartextBuf = ByteBuffer.allocate(40);
        try {
            DestroyableSecretKey ek = this.masterkey.getEncKey();
            try {
                Cipher cipher = CipherSupplier.AES_CTR.forDecryption(ek, new IvParameterSpec(nonce));
                assert (cipher.getOutputSize(ciphertextPayload.length) == payloadCleartextBuf.remaining());
                int decrypted = cipher.doFinal(ByteBuffer.wrap(ciphertextPayload), payloadCleartextBuf);
                assert (decrypted == 40);
                payloadCleartextBuf.flip();
                FileHeaderImpl.Payload payload = FileHeaderImpl.Payload.decode(payloadCleartextBuf);
                FileHeaderImpl fileHeaderImpl = new FileHeaderImpl(nonce, payload);
                if (ek != null) {
                    ek.close();
                }
                return fileHeaderImpl;
            }
            catch (Throwable throwable) {
                try {
                    if (ek != null) {
                        try {
                            ek.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ShortBufferException e) {
                    throw new IllegalStateException("Result buffer too small for decrypted header payload.", e);
                }
                catch (BadPaddingException | IllegalBlockSizeException e) {
                    throw new IllegalStateException("Unexpected exception for CTR ciphers.", e);
                }
            }
        }
        finally {
            Arrays.fill(payloadCleartextBuf.array(), (byte)0);
        }
    }
}

