/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure;

import com.dokany.java.constants.DokanOption;
import com.dokany.java.structure.EnumIntegerSet;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DeviceOptions
extends Structure
implements Structure.ByReference {
    public short Version = (short)110;
    public short ThreadCount;
    public int Options;
    private EnumIntegerSet<DokanOption> dokanOptions;
    public long GlobalContext = 0L;
    public WString MountPoint;
    public WString UNCName;
    public long Timeout;
    public long AllocationUnitSize;
    public long SectorSize;

    public DeviceOptions() {
    }

    public DeviceOptions(String mountPoint, short threadCount, EnumIntegerSet<DokanOption> dokanOptions, String uncName, long timeout, long allocationUnitSize, long sectorSize) {
        this.MountPoint = new WString(mountPoint);
        this.ThreadCount = threadCount;
        this.dokanOptions = dokanOptions;
        this.Options = dokanOptions.toInt();
        this.UNCName = Objects.nonNull(uncName) ? new WString(uncName) : null;
        this.Timeout = timeout;
        this.AllocationUnitSize = allocationUnitSize;
        this.SectorSize = sectorSize;
    }

    public EnumIntegerSet<DokanOption> getDokanOptions() {
        return this.dokanOptions;
    }

    protected List<String> getFieldOrder() {
        return Arrays.asList("Version", "ThreadCount", "Options", "GlobalContext", "MountPoint", "UNCName", "Timeout", "AllocationUnitSize", "SectorSize");
    }

    public String toString() {
        return "DeviceOptions(Version=" + this.Version + ", ThreadCount=" + this.ThreadCount + ", Options=" + this.Options + ", mountOptions=" + this.getDokanOptions() + ", GlobalContext=" + this.GlobalContext + ", MountPoint=" + this.MountPoint + ", UNCName=" + this.UNCName + ", Timeout=" + this.Timeout + ", AllocationUnitSize=" + this.AllocationUnitSize + ", SectorSize=" + this.SectorSize + ")";
    }
}

