/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.masterkeyfile;

import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeyLoadingScoped
class MasterkeyFileLoadingFinisher {
    private static final Logger LOG = LoggerFactory.getLogger(MasterkeyFileLoadingFinisher.class);
    private final Vault vault;
    private final Optional<char[]> storedPassword;
    private final AtomicReference<char[]> enteredPassword;
    private final AtomicBoolean shouldSavePassword;
    private final KeychainManager keychain;

    @Inject
    MasterkeyFileLoadingFinisher(@KeyLoading Vault vault, @Named(value="savedPassword") Optional<char[]> storedPassword, AtomicReference<char[]> enteredPassword, @Named(value="savePassword") AtomicBoolean shouldSavePassword, KeychainManager keychain) {
        this.vault = vault;
        this.storedPassword = storedPassword;
        this.enteredPassword = enteredPassword;
        this.shouldSavePassword = shouldSavePassword;
        this.keychain = keychain;
    }

    public void cleanup(boolean successfullyUnlocked) {
        if (successfullyUnlocked && this.shouldSavePassword.get()) {
            this.savePasswordToSystemkeychain();
        }
        this.wipePassword(this.storedPassword.orElse(null));
        this.wipePassword(this.enteredPassword.getAndSet(null));
    }

    private void savePasswordToSystemkeychain() {
        if (this.keychain.isSupported()) {
            try {
                this.keychain.storePassphrase(this.vault.getId(), CharBuffer.wrap(this.enteredPassword.get()));
            }
            catch (KeychainAccessException e) {
                LOG.error("Failed to store passphrase in system keychain.", (Throwable)e);
            }
        }
    }

    private void wipePassword(char[] pw) {
        if (pw != null) {
            Arrays.fill(pw, ' ');
        }
    }
}

