/* ControlManager.h - Menu suppor class to 
   the Control menu functions for the 
   Macintosh OS X SDL port of Atari800
   Mark Grebe <atarimac@cox.net>
   
   Based on the Preferences pane of the
   TextEdit application.

*/
#import <Cocoa/Cocoa.h>

@interface ControlManager : NSObject
{
    IBOutlet id coldResetItem;
    IBOutlet id limitItem;
    IBOutlet id loadStateItem;
    IBOutlet id pauseItem;
    IBOutlet id saveStateItem;
    IBOutlet id warmResetItem;
    IBOutlet id errorTextField;
    IBOutlet id messageOutputView;
    IBOutlet id monitorOutputView;
    IBOutlet id monitorInputField;
    IBOutlet id monitorExeButton;
    IBOutlet id monitorDoneButton;
}
+ (ControlManager *)sharedInstance;
- (void)setLimitMenu:(int)limit;
- (NSString *) browseFileInDirectory:(NSString *)directory;
- (NSString *) saveFileInDirectory:(NSString *)directory:(NSString *)type;
- (IBAction)coldReset:(id)sender;
- (IBAction)limit:(id)sender;
- (IBAction)loadState:(id)sender;
- (void)loadStateFile:(NSString *)filename;
- (IBAction)pause:(id)sender;
- (IBAction)saveState:(id)sender;
- (IBAction)warmReset:(id)sender;
- (int)fatalError;
- (IBAction)coldStartSelected:(id)sender;
- (IBAction)ejectCartridgeSelected:(id)sender;
- (IBAction)ejectDiskSelected:(id)sender;
- (IBAction)coldStartSelected:(id)sender;
- (IBAction)warmStartSelected:(id)sender;
- (IBAction)monitorSelected:(id)sender;
- (IBAction)quitSelected:(id)sender;
- (void) releaseCmdKeys:(NSString *)character:(int)keyCode;
- (void) releaseKey:(int)keyCode;
- (IBAction)monitorExecute:(id)sender;
- (void)messagePrint:(char *)printString;
- (void)messageWindowShow:(id)sender;
- (void)monitorPrint:(char *)string;
- (IBAction)monitorMenuRun:(id)sender;
- (int)monitorRun;
@end
