/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _BCACHEFS_EC_TYPES_H
#define _BCACHEFS_EC_TYPES_H

#include <linux/llist.h>

struct bch_replicas_padded {
	struct bch_replicas_entry	e;
	u8				pad[BCH_BKEY_PTRS_MAX];
};

struct stripe {
	size_t			heap_idx;

	u16			sectors;
	u8			algorithm;

	u8			nr_blocks;
	u8			nr_redundant;

	unsigned		alive:1; /* does a corresponding key exist in stripes btree? */
	unsigned		on_heap:1;
	u8			blocks_nonempty;
};

struct gc_stripe {
	u16			sectors;

	u8			nr_blocks;
	u8			nr_redundant;

	unsigned		alive:1; /* does a corresponding key exist in stripes btree? */
	u16			block_sectors[BCH_BKEY_PTRS_MAX];
	struct bch_extent_ptr	ptrs[BCH_BKEY_PTRS_MAX];

	struct bch_replicas_padded r;
};

struct ec_stripe_heap_entry {
	size_t			idx;
	unsigned		blocks_nonempty;
};

typedef HEAP(struct ec_stripe_heap_entry) ec_stripes_heap;

#endif /* _BCACHEFS_EC_TYPES_H */
