'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = prefixer;

var _staticData = require('inline-style-prefixer/static/staticData');

var _staticData2 = _interopRequireDefault(_staticData);

var _prefixProperty = require('inline-style-prefixer/utils/prefixProperty');

var _prefixProperty2 = _interopRequireDefault(_prefixProperty);

var _prefixValue = require('inline-style-prefixer/utils/prefixValue');

var _prefixValue2 = _interopRequireDefault(_prefixValue);

var _cursor = require('inline-style-prefixer/static/plugins/cursor');

var _cursor2 = _interopRequireDefault(_cursor);

var _crossFade = require('inline-style-prefixer/static/plugins/crossFade');

var _crossFade2 = _interopRequireDefault(_crossFade);

var _filter = require('inline-style-prefixer/static/plugins/filter');

var _filter2 = _interopRequireDefault(_filter);

var _flex = require('inline-style-prefixer/static/plugins/flex');

var _flex2 = _interopRequireDefault(_flex);

var _flexboxOld = require('inline-style-prefixer/static/plugins/flexboxOld');

var _flexboxOld2 = _interopRequireDefault(_flexboxOld);

var _gradient = require('inline-style-prefixer/static/plugins/gradient');

var _gradient2 = _interopRequireDefault(_gradient);

var _imageSet = require('inline-style-prefixer/static/plugins/imageSet');

var _imageSet2 = _interopRequireDefault(_imageSet);

var _position = require('inline-style-prefixer/static/plugins/position');

var _position2 = _interopRequireDefault(_position);

var _sizing = require('inline-style-prefixer/static/plugins/sizing');

var _sizing2 = _interopRequireDefault(_sizing);

var _transition = require('inline-style-prefixer/static/plugins/transition');

var _transition2 = _interopRequireDefault(_transition);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var plugins = [_crossFade2.default, _cursor2.default, _filter2.default, _flexboxOld2.default, _gradient2.default, _imageSet2.default, _position2.default, _sizing2.default, _transition2.default, _flex2.default];
// custom facade for inline-style-prefixer

var prefixMap = _staticData2.default.prefixMap;

function prefixer(style) {
  for (var property in style) {
    var value = style[property];

    var processedValue = (0, _prefixValue2.default)(plugins, property, value, style, prefixMap);

    // only modify the value if it was touched
    // by any plugin to prevent unnecessary mutations
    if (processedValue) {
      style[property] = processedValue;
    }

    (0, _prefixProperty2.default)(prefixMap, property, style);
  }
  return style;
}