'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _noImportant = require('aphrodite/no-important');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Spinner = function Spinner(props) {
  var classes = _noImportant.StyleSheet.create(styles(props));

  return _react2.default.createElement(
    'div',
    { className: (0, _noImportant.css)(classes.spinner) },
    _react2.default.createElement('div', { className: (0, _noImportant.css)(classes.ripple) })
  );
};

Spinner.propTypes = {
  color: _propTypes2.default.string,
  size: _propTypes2.default.number
};

var rippleKeyframes = {
  '0%': {
    top: '50%',
    left: '50%',
    width: 0,
    height: 0,
    opacity: 1
  },
  '100%': {
    top: 0,
    left: 0,
    width: '100%',
    height: '100%',
    opacity: 0
  }
};

var styles = function styles(_ref) {
  var color = _ref.color,
      size = _ref.size;
  return {
    spinner: {
      display: 'inline-block',
      position: 'relative',
      width: size,
      height: size
    },
    ripple: {
      position: 'absolute',
      border: '4px solid ' + color,
      opacity: 1,
      borderRadius: '50%',
      animationName: rippleKeyframes,
      animationDuration: '1s',
      animationTimingFunction: 'cubic-bezier(0, 0.2, 0.8, 1)',
      animationIterationCount: 'infinite'
    }
  };
};

exports.default = Spinner;