/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: SmartTextTab.java
 *
 * Copyright (c) 2006, Static Free Software. All rights reserved.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;

import javax.swing.JPanel;

/**
 * Class to handle the "Smart Text" tab of the Preferences dialog.
 */
public class SmartTextTab extends PreferencePanel
{
	/** Creates new form SmartTextTab */
	public SmartTextTab(PreferencesFrame parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
	}

	/** return the panel to use for user preferences. */
    @Override
	public JPanel getUserPreferencesPanel() { return text; }

	/** return the name of this preferences tab. */
    @Override
	public String getName() { return "Smart Text"; }

	/**
	 * Method called at the start of the dialog.
	 * Caches current values and displays them in the Text tab.
	 */
    @Override
	public void init()
	{
        EditingPreferences ep = getEditingPreferences();
		// set arc defaults
		switch (ep.getSmartVerticalPlacementArc())
		{
			case 0: arcVerticalInside.setSelected(true);    break;
			case 1: arcVerticalLeft.setSelected(true);      break;
			case 2: arcVerticalRight.setSelected(true);     break;
		}
		switch (ep.getSmartHorizontalPlacementArc())
		{
			case 0: arcHorizontalInside.setSelected(true);    break;
			case 1: arcHorizontalAbove.setSelected(true);     break;
			case 2: arcHorizontalBelow.setSelected(true);     break;
		}

		// set export defaults
		switch (ep.getSmartVerticalPlacementExport())
		{
			case 0: textSmartVerticalOff.setSelected(true);       break;
			case 1: textSmartVerticalInside.setSelected(true);    break;
			case 2: textSmartVerticalOutside.setSelected(true);   break;
		}
		switch (ep.getSmartHorizontalPlacementExport())
		{
			case 0: textSmartHorizontalOff.setSelected(true);       break;
			case 1: textSmartHorizontalInside.setSelected(true);    break;
			case 2: textSmartHorizontalOutside.setSelected(true);   break;
		}
	}

	/**
	 * Method called when the "OK" panel is hit.
	 * Updates any changed fields in the Text tab.
	 */
    @Override
	public void term()
	{
        EditingPreferences ep = getEditingPreferences();
		// set arc changes
		int currInt = 0;
		if (arcVerticalLeft.isSelected()) currInt = 1; else
			if (arcVerticalRight.isSelected()) currInt = 2;
        ep = ep.withSmartVerticalPlacementArc(currInt);

		currInt = 0;
		if (arcHorizontalAbove.isSelected()) currInt = 1; else
			if (arcHorizontalBelow.isSelected()) currInt = 2;
        ep = ep.withSmartHorizontalPlacementArc(currInt);

		// set export changes
		currInt = 0;
		if (textSmartVerticalInside.isSelected()) currInt = 1; else
			if (textSmartVerticalOutside.isSelected()) currInt = 2;
        ep = ep.withSmartVerticalPlacementExport(currInt);

		currInt = 0;
		if (textSmartHorizontalInside.isSelected()) currInt = 1; else
			if (textSmartHorizontalOutside.isSelected()) currInt = 2;
        ep = ep.withSmartHorizontalPlacementExport(currInt);
        setEditingPreferences(ep);
	}

	/**
	 * Method called when the factory reset is requested.
	 */
    @Override
	public void reset()
	{
        setEditingPreferences(getEditingPreferences().withPlacementReset());
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;

        arcVerticalGroup = new javax.swing.ButtonGroup();
        arcHorizontalGroup = new javax.swing.ButtonGroup();
        exportVerticalGroup = new javax.swing.ButtonGroup();
        exportHorizontalGroup = new javax.swing.ButtonGroup();
        text = new javax.swing.JPanel();
        exportText = new javax.swing.JPanel();
        jLabel56 = new javax.swing.JLabel();
        textSmartVerticalOff = new javax.swing.JRadioButton();
        textSmartVerticalInside = new javax.swing.JRadioButton();
        textSmartVerticalOutside = new javax.swing.JRadioButton();
        jLabel57 = new javax.swing.JLabel();
        textSmartHorizontalOff = new javax.swing.JRadioButton();
        textSmartHorizontalInside = new javax.swing.JRadioButton();
        textSmartHorizontalOutside = new javax.swing.JRadioButton();
        arcText = new javax.swing.JPanel();
        jLabel58 = new javax.swing.JLabel();
        arcVerticalInside = new javax.swing.JRadioButton();
        arcVerticalLeft = new javax.swing.JRadioButton();
        arcVerticalRight = new javax.swing.JRadioButton();
        jLabel59 = new javax.swing.JLabel();
        arcHorizontalInside = new javax.swing.JRadioButton();
        arcHorizontalAbove = new javax.swing.JRadioButton();
        arcHorizontalBelow = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Edit Options");
        setName("");
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                closeDialog(evt);
            }
        });

        text.setLayout(new java.awt.GridBagLayout());

        exportText.setLayout(new java.awt.GridBagLayout());

        exportText.setBorder(javax.swing.BorderFactory.createTitledBorder("Smart Placement of Export Text"));
        jLabel56.setText("Near cell top/bottom:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        exportText.add(jLabel56, gridBagConstraints);

        exportVerticalGroup.add(textSmartVerticalOff);
        textSmartVerticalOff.setText("Off");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        exportText.add(textSmartVerticalOff, gridBagConstraints);

        exportVerticalGroup.add(textSmartVerticalInside);
        textSmartVerticalInside.setText("Inside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        exportText.add(textSmartVerticalInside, gridBagConstraints);

        exportVerticalGroup.add(textSmartVerticalOutside);
        textSmartVerticalOutside.setText("Outside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        exportText.add(textSmartVerticalOutside, gridBagConstraints);

        jLabel57.setText("Near cell left/right:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        exportText.add(jLabel57, gridBagConstraints);

        exportHorizontalGroup.add(textSmartHorizontalOff);
        textSmartHorizontalOff.setText("Off");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        exportText.add(textSmartHorizontalOff, gridBagConstraints);

        exportHorizontalGroup.add(textSmartHorizontalInside);
        textSmartHorizontalInside.setText("Inside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        exportText.add(textSmartHorizontalInside, gridBagConstraints);

        exportHorizontalGroup.add(textSmartHorizontalOutside);
        textSmartHorizontalOutside.setText("Outside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        exportText.add(textSmartHorizontalOutside, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        text.add(exportText, gridBagConstraints);

        arcText.setLayout(new java.awt.GridBagLayout());

        arcText.setBorder(javax.swing.BorderFactory.createTitledBorder("Smart Placement of Arc Text"));
        jLabel58.setText("Vertical arcs:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        arcText.add(jLabel58, gridBagConstraints);

        arcVerticalGroup.add(arcVerticalInside);
        arcVerticalInside.setText("Inside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        arcText.add(arcVerticalInside, gridBagConstraints);

        arcVerticalGroup.add(arcVerticalLeft);
        arcVerticalLeft.setText("Left");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        arcText.add(arcVerticalLeft, gridBagConstraints);

        arcVerticalGroup.add(arcVerticalRight);
        arcVerticalRight.setText("Right");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        arcText.add(arcVerticalRight, gridBagConstraints);

        jLabel59.setText("Horizontal arcs:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        arcText.add(jLabel59, gridBagConstraints);

        arcHorizontalGroup.add(arcHorizontalInside);
        arcHorizontalInside.setText("Inside");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        arcText.add(arcHorizontalInside, gridBagConstraints);

        arcHorizontalGroup.add(arcHorizontalAbove);
        arcHorizontalAbove.setText("Above");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        arcText.add(arcHorizontalAbove, gridBagConstraints);

        arcHorizontalGroup.add(arcHorizontalBelow);
        arcHorizontalBelow.setText("Below");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        arcText.add(arcHorizontalBelow, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        text.add(arcText, gridBagConstraints);

        jLabel1.setText("Smart Text placement indicates the");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 1, 0);
        text.add(jLabel1, gridBagConstraints);

        jLabel2.setText("default location of new text");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 4, 10, 0);
        text.add(jLabel2, gridBagConstraints);

        getContentPane().add(text, new java.awt.GridBagConstraints());

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton arcHorizontalAbove;
    private javax.swing.JRadioButton arcHorizontalBelow;
    private javax.swing.ButtonGroup arcHorizontalGroup;
    private javax.swing.JRadioButton arcHorizontalInside;
    private javax.swing.JPanel arcText;
    private javax.swing.ButtonGroup arcVerticalGroup;
    private javax.swing.JRadioButton arcVerticalInside;
    private javax.swing.JRadioButton arcVerticalLeft;
    private javax.swing.JRadioButton arcVerticalRight;
    private javax.swing.ButtonGroup exportHorizontalGroup;
    private javax.swing.JPanel exportText;
    private javax.swing.ButtonGroup exportVerticalGroup;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel56;
    private javax.swing.JLabel jLabel57;
    private javax.swing.JLabel jLabel58;
    private javax.swing.JLabel jLabel59;
    private javax.swing.JPanel text;
    private javax.swing.JRadioButton textSmartHorizontalInside;
    private javax.swing.JRadioButton textSmartHorizontalOff;
    private javax.swing.JRadioButton textSmartHorizontalOutside;
    private javax.swing.JRadioButton textSmartVerticalInside;
    private javax.swing.JRadioButton textSmartVerticalOff;
    private javax.swing.JRadioButton textSmartVerticalOutside;
    // End of variables declaration//GEN-END:variables

}
