/*
 * Decompiled with CFR 0.152.
 */
package xades4j.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import xades4j.algorithms.XPathTransformBase;

public final class XPath2FilterTransform
extends XPathTransformBase {
    private final List<XPath2Filter> filters = new ArrayList<XPath2Filter>(2);

    private XPath2FilterTransform() {
        super("http://www.w3.org/2002/06/xmldsig-filter2");
    }

    public XPath2FilterTransform intersect(String xpath) {
        this.filters.add(new XPath2Filter("intersect", xpath));
        return this;
    }

    public XPath2FilterTransform subtract(String xpath) {
        this.filters.add(new XPath2Filter("subtract", xpath));
        return this;
    }

    public XPath2FilterTransform union(String xpath) {
        this.filters.add(new XPath2Filter("union", xpath));
        return this;
    }

    public List<XPath2Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public XPath2FilterTransform withNamespace(String prefix, String namespace) {
        this.addNamespace(prefix, namespace);
        return this;
    }

    public static final class XPath2Filter {
        private final String filterType;
        private final String xpath;

        private XPath2Filter(String filterType, String xpath) {
            if (null == xpath) {
                throw new NullPointerException("XPath expression cannot be null");
            }
            this.filterType = filterType;
            this.xpath = xpath;
        }

        public String getFilterType() {
            return this.filterType;
        }

        public String getXPath() {
            return this.xpath;
        }

        public static XPath2FilterTransform intersect(String xpath) {
            return new XPath2FilterTransform().intersect(xpath);
        }

        public static XPath2FilterTransform subtract(String xpath) {
            return new XPath2FilterTransform().subtract(xpath);
        }

        public static XPath2FilterTransform union(String xpath) {
            return new XPath2FilterTransform().union(xpath);
        }
    }
}

