/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertyDataGenerationException;
import xades4j.production.PropertyDataObjectGenerator;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.TimeStampTokenGenerationException;
import xades4j.providers.TimeStampTokenProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;

abstract class DataGenBaseTimeStamp<TProp extends QualifyingProperty>
implements PropertyDataObjectGenerator<TProp> {
    private final AlgorithmsProviderEx algsProvider;
    private final TimeStampTokenProvider tsTokenProvider;
    private final TimeStampDigestInputFactory tsInputFactory;

    public DataGenBaseTimeStamp(AlgorithmsProviderEx algsProvider, TimeStampTokenProvider tsTokenProvider, TimeStampDigestInputFactory tsInputFactory) {
        this.algsProvider = algsProvider;
        this.tsTokenProvider = tsTokenProvider;
        this.tsInputFactory = tsInputFactory;
    }

    @Override
    public final PropertyDataObject generatePropertyData(TProp prop, PropertiesDataGenerationContext ctx) throws PropertyDataGenerationException {
        Algorithm c14n = this.algsProvider.getCanonicalizationAlgorithmForTimeStampProperties();
        try {
            TimeStampDigestInput digestInput = this.tsInputFactory.newTimeStampDigestInput(c14n);
            this.addPropSpecificTimeStampInput(prop, digestInput, ctx);
            TimeStampTokenProvider.TimeStampTokenRes tsTknRes = this.tsTokenProvider.getTimeStampToken(digestInput.getBytes(), this.algsProvider.getDigestAlgorithmForTimeStampProperties());
            return this.createPropDataObj(prop, c14n, tsTknRes, ctx);
        }
        catch (UnsupportedAlgorithmException ex) {
            throw new PropertyDataGenerationException((QualifyingProperty)prop, ex.getMessage(), ex);
        }
        catch (CannotAddDataToDigestInputException ex) {
            throw new PropertyDataGenerationException((QualifyingProperty)prop, "cannot create time stamp input", ex);
        }
        catch (TimeStampTokenGenerationException ex) {
            throw new PropertyDataGenerationException((QualifyingProperty)prop, "cannot get a time-stamp", ex);
        }
    }

    protected abstract void addPropSpecificTimeStampInput(TProp var1, TimeStampDigestInput var2, PropertiesDataGenerationContext var3) throws CannotAddDataToDigestInputException, PropertyDataGenerationException;

    protected abstract BaseXAdESTimeStampData createPropDataObj(TProp var1, Algorithm var2, TimeStampTokenProvider.TimeStampTokenRes var3, PropertiesDataGenerationContext var4);
}

