/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xades4j.XAdES4jXMLSigException;
import xades4j.properties.DataObjectDesc;
import xades4j.utils.DOMHelper;

public class PropertiesDataGenerationContext {
    private final List<Reference> references;
    private final Map<DataObjectDesc, Reference> referencesMappings;
    private final Document sigDocument;
    private XMLSignature targetXmlSignature;

    PropertiesDataGenerationContext(XMLSignature targetXmlSignature) throws XAdES4jXMLSigException {
        this.targetXmlSignature = targetXmlSignature;
        this.sigDocument = targetXmlSignature.getDocument();
        this.referencesMappings = null;
        SignedInfo signedInfo = targetXmlSignature.getSignedInfo();
        ArrayList<Reference> refs = new ArrayList<Reference>(signedInfo.getLength());
        for (int i = 0; i < signedInfo.getLength(); ++i) {
            try {
                refs.add(signedInfo.item(i));
                continue;
            }
            catch (XMLSecurityException ex) {
                throw new XAdES4jXMLSigException(String.format("Cannot process the %dth reference", i), ex);
            }
        }
        this.references = Collections.unmodifiableList(refs);
    }

    PropertiesDataGenerationContext(Collection<DataObjectDesc> orderedDataObjs, Map<DataObjectDesc, Reference> referencesMappings, Document sigDocument) {
        this.referencesMappings = referencesMappings;
        this.sigDocument = sigDocument;
        ArrayList<Reference> orderedRefs = new ArrayList<Reference>(orderedDataObjs.size());
        for (DataObjectDesc dataObjDesc : orderedDataObjs) {
            orderedRefs.add(referencesMappings.get(dataObjDesc));
        }
        this.references = Collections.unmodifiableList(orderedRefs);
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public Map<DataObjectDesc, Reference> getReferencesMappings() {
        return this.referencesMappings;
    }

    public XMLSignature getTargetXmlSignature() {
        return this.targetXmlSignature;
    }

    void setTargetXmlSignature(XMLSignature targetXmlSignature) {
        if (this.targetXmlSignature != null) {
            throw new IllegalStateException("TargetXMLSignature already set");
        }
        this.targetXmlSignature = targetXmlSignature;
    }

    Document getSignatureDocument() {
        return this.sigDocument;
    }

    public Element createElementInSignatureDoc(String name, String prefix, String namespace) {
        return DOMHelper.createElement(this.sigDocument, name, prefix, namespace);
    }
}

