/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.UnsupportedAlgorithmException;
import xades4j.XAdES4jException;
import xades4j.XAdES4jXMLSigException;
import xades4j.algorithms.Algorithm;
import xades4j.production.BasicSignatureOptions;
import xades4j.production.Init;
import xades4j.production.KeyInfoBuilder;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertiesDataObjectsGenerator;
import xades4j.production.QualifyingPropertiesProcessor;
import xades4j.production.SignatureAppendingStrategies;
import xades4j.production.SignedDataObjects;
import xades4j.production.SignedDataObjectsProcessor;
import xades4j.production.XadesSignatureResult;
import xades4j.production.XadesSigner;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.QualifyingProperties;
import xades4j.properties.SignedSignatureProperty;
import xades4j.properties.SigningCertificateProperty;
import xades4j.properties.UnsignedSignatureProperty;
import xades4j.properties.data.SigAndDataObjsPropertiesData;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.DataObjectPropertiesProvider;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.SignaturePropertiesProvider;
import xades4j.providers.SigningCertChainException;
import xades4j.providers.X500NameStyleProvider;
import xades4j.utils.CanonicalizerUtils;
import xades4j.utils.DOMHelper;
import xades4j.utils.ObjectUtils;
import xades4j.utils.StringUtils;
import xades4j.utils.TransformUtils;
import xades4j.xml.marshalling.SignedPropertiesMarshaller;
import xades4j.xml.marshalling.UnsignedPropertiesMarshaller;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class SignerBES
implements XadesSigner {
    private final KeyingDataProvider keyingProvider;
    private final AlgorithmsProviderEx algorithmsProvider;
    private final SignedDataObjectsProcessor dataObjectDescsProcessor;
    private final PropertiesDataObjectsGenerator propsDataObjectsGenerator;
    private final SignedPropertiesMarshaller signedPropsMarshaller;
    private final UnsignedPropertiesMarshaller unsignedPropsMarshaller;
    private final AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller;
    private final X500NameStyleProvider x500NameStyleProvider;
    private final KeyInfoBuilder keyInfoBuilder;
    private final QualifyingPropertiesProcessor qualifPropsProcessor;

    @Inject
    protected SignerBES(KeyingDataProvider keyingProvider, AlgorithmsProviderEx algorithmsProvider, BasicSignatureOptions basicSignatureOptions, SignedDataObjectsProcessor dataObjectDescsProcessor, SignaturePropertiesProvider signaturePropsProvider, DataObjectPropertiesProvider dataObjPropsProvider, PropertiesDataObjectsGenerator propsDataObjectsGenerator, SignedPropertiesMarshaller signedPropsMarshaller, UnsignedPropertiesMarshaller unsignedPropsMarshaller, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller, X500NameStyleProvider x500NameStyleProvider) {
        if (ObjectUtils.anyNull(keyingProvider, algorithmsProvider, basicSignatureOptions, signaturePropsProvider, dataObjPropsProvider, propsDataObjectsGenerator, signedPropsMarshaller, unsignedPropsMarshaller, algorithmsParametersMarshaller, x500NameStyleProvider)) {
            throw new NullPointerException("One or more arguments are null");
        }
        this.keyingProvider = keyingProvider;
        this.algorithmsProvider = algorithmsProvider;
        this.propsDataObjectsGenerator = propsDataObjectsGenerator;
        this.signedPropsMarshaller = signedPropsMarshaller;
        this.unsignedPropsMarshaller = unsignedPropsMarshaller;
        this.algorithmsParametersMarshaller = algorithmsParametersMarshaller;
        this.x500NameStyleProvider = x500NameStyleProvider;
        this.dataObjectDescsProcessor = dataObjectDescsProcessor;
        this.keyInfoBuilder = new KeyInfoBuilder(basicSignatureOptions, algorithmsProvider, algorithmsParametersMarshaller, x500NameStyleProvider);
        this.qualifPropsProcessor = new QualifyingPropertiesProcessor(signaturePropsProvider, dataObjPropsProvider);
    }

    @Override
    public final XadesSignatureResult sign(SignedDataObjects signedDataObjects, Node parent) throws XAdES4jException {
        return this.sign(signedDataObjects, parent, SignatureAppendingStrategies.AsLastChild);
    }

    @Override
    public final XadesSignatureResult sign(SignedDataObjects signedDataObjects, Node referenceNode, XadesSigner.SignatureAppendingStrategy appendingStrategy) throws XAdES4jException {
        if (null == referenceNode) {
            throw new NullPointerException("Reference node node cannot be null");
        }
        if (null == signedDataObjects) {
            throw new NullPointerException("References cannot be null");
        }
        if (signedDataObjects.isEmpty()) {
            throw new IllegalArgumentException("Data objects list is empty");
        }
        Document signatureDocument = DOMHelper.getOwnerDocument(referenceNode);
        String signatureId = String.format("xmldsig-%s", UUID.randomUUID());
        String signedPropsId = String.format("%s-signedprops", signatureId);
        List<X509Certificate> signingCertificateChain = this.keyingProvider.getSigningCertificateChain();
        if (null == signingCertificateChain || signingCertificateChain.isEmpty()) {
            throw new SigningCertChainException("Signing certificate not provided");
        }
        X509Certificate signingCertificate = signingCertificateChain.get(0);
        XMLSignature signature = this.createSignature(signatureDocument, signedDataObjects.getBaseUri(), signingCertificate.getPublicKey().getAlgorithm());
        signature.setId(signatureId);
        Map<DataObjectDesc, Reference> referenceMappings = this.dataObjectDescsProcessor.process(signedDataObjects, signature);
        this.keyInfoBuilder.buildKeyInfo(signingCertificateChain, signature);
        Element qualifyingPropsElem = ElementProxy.createElementForFamily((Document)signature.getDocument(), (String)"http://uri.etsi.org/01903/v1.3.2#", (String)"QualifyingProperties");
        qualifyingPropsElem.setAttributeNS(null, "Target", '#' + signatureId);
        qualifyingPropsElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades141", "http://uri.etsi.org/01903/v1.4.1#");
        ObjectContainer qPropsXmlObj = new ObjectContainer(signature.getDocument());
        qPropsXmlObj.appendChild((Node)qualifyingPropsElem);
        try {
            signature.appendObject(qPropsXmlObj);
        }
        catch (XMLSignatureException ex) {
            throw new IllegalStateException(ex);
        }
        ArrayList<SignedSignatureProperty> fsssp = new ArrayList<SignedSignatureProperty>(2);
        ArrayList<UnsignedSignatureProperty> fsusp = new ArrayList<UnsignedSignatureProperty>(2);
        this.getFormatSpecificSignatureProperties(fsssp, fsusp, signingCertificateChain);
        QualifyingProperties qualifProps = this.qualifPropsProcessor.getQualifyingProperties(signedDataObjects, fsssp, fsusp);
        try {
            appendingStrategy.append(signature.getElement(), referenceNode);
            PropertiesDataGenerationContext propsDataGenCtx = new PropertiesDataGenerationContext(signedDataObjects.getDataObjectsDescs(), referenceMappings, signatureDocument);
            SigAndDataObjsPropertiesData signedPropsData = this.propsDataObjectsGenerator.generateSignedPropertiesData(qualifProps.getSignedProperties(), propsDataGenCtx);
            this.signedPropsMarshaller.marshal(signedPropsData, qualifyingPropsElem);
            Element signedPropsElem = DOMHelper.getFirstChildElement(qualifyingPropsElem);
            DOMHelper.setIdAsXmlId(signedPropsElem, signedPropsId);
            String digestAlgUri = this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences();
            if (StringUtils.isNullOrEmptyString(digestAlgUri)) {
                throw new NullPointerException("Digest algorithm URI not provided");
            }
            Algorithm canonAlg = this.algorithmsProvider.getCanonicalizationAlgorithmForSignature();
            try {
                CanonicalizerUtils.checkC14NAlgorithm(canonAlg);
                Transforms transforms = TransformUtils.createTransforms(canonAlg, this.algorithmsParametersMarshaller, signatureDocument);
                signature.addDocument('#' + signedPropsId, transforms, digestAlgUri, null, "http://uri.etsi.org/01903#SignedProperties");
            }
            catch (XMLSignatureException ex) {
                throw new UnsupportedAlgorithmException("Digest algorithm not supported in the XML Signature provider", digestAlgUri, ex);
            }
            try {
                PrivateKey signingKey = this.keyingProvider.getSigningKey(signingCertificate);
                signature.sign((Key)signingKey);
            }
            catch (XMLSignatureException ex) {
                throw new XAdES4jXMLSigException(ex.getMessage(), ex);
            }
            Element sigValueElem = DOMHelper.getFirstDescendant(signature.getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            DOMHelper.setIdAsXmlId(sigValueElem, String.format("%s-sigvalue", signatureId));
            propsDataGenCtx.setTargetXmlSignature(signature);
            SigAndDataObjsPropertiesData unsignedPropsData = this.propsDataObjectsGenerator.generateUnsignedPropertiesData(qualifProps.getUnsignedProperties(), propsDataGenCtx);
            this.unsignedPropsMarshaller.marshal(unsignedPropsData, qualifyingPropsElem);
        }
        catch (XAdES4jException ex) {
            appendingStrategy.revert(signature.getElement(), referenceNode);
            throw ex;
        }
        return new XadesSignatureResult(signature, qualifProps);
    }

    private XMLSignature createSignature(Document signatureDocument, String baseUri, String signingKeyAlgorithm) throws XAdES4jXMLSigException, UnsupportedAlgorithmException {
        Algorithm signatureAlg = this.algorithmsProvider.getSignatureAlgorithm(signingKeyAlgorithm);
        if (null == signatureAlg) {
            throw new NullPointerException("Signature algorithm not provided");
        }
        Element signatureAlgElem = this.createElementForAlgorithm(signatureAlg, "SignatureMethod", signatureDocument);
        Algorithm canonAlg = this.algorithmsProvider.getCanonicalizationAlgorithmForSignature();
        if (null == canonAlg) {
            throw new NullPointerException("Canonicalization algorithm not provided");
        }
        Element canonAlgElem = this.createElementForAlgorithm(canonAlg, "CanonicalizationMethod", signatureDocument);
        try {
            return new XMLSignature(signatureDocument, baseUri, signatureAlgElem, canonAlgElem);
        }
        catch (XMLSecurityException ex) {
            throw new XAdES4jXMLSigException(ex.getMessage(), ex);
        }
    }

    private Element createElementForAlgorithm(Algorithm algorithm, String elementName, Document signatureDocument) throws UnsupportedAlgorithmException {
        Element algorithmElem = XMLUtils.createElementInSignatureSpace((Document)signatureDocument, (String)elementName);
        algorithmElem.setAttributeNS(null, "Algorithm", algorithm.getUri());
        List<Node> algorithmParams = this.algorithmsParametersMarshaller.marshalParameters(algorithm, signatureDocument);
        if (algorithmParams != null) {
            for (Node p : algorithmParams) {
                algorithmElem.appendChild(p);
            }
        }
        return algorithmElem;
    }

    protected void getFormatSpecificSignatureProperties(Collection<SignedSignatureProperty> formatSpecificSignedSigProps, Collection<UnsignedSignatureProperty> formatSpecificUnsignedSigProps, List<X509Certificate> signingCertificateChain) throws XAdES4jException {
        SigningCertificateProperty scp = new SigningCertificateProperty(signingCertificateChain);
        formatSpecificSignedSigProps.add(scp);
    }

    static {
        Init.initXMLSec();
    }
}

