/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xades4j.properties.data.GenericDOMData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.SigAndDataObjsPropertiesData;
import xades4j.utils.CollectionUtils;
import xades4j.utils.DOMHelper;
import xades4j.xml.bind.xades.ObjectFactory;
import xades4j.xml.bind.xades.XmlSignedPropertiesType;
import xades4j.xml.bind.xades.XmlUnsignedPropertiesType;
import xades4j.xml.marshalling.MarshalException;
import xades4j.xml.marshalling.QualifyingPropertyDataToXmlConverter;
import xades4j.xml.marshalling.UnsupportedDataObjectException;

abstract class BaseJAXBMarshaller<TXml> {
    private static final Map<Class, JAXBContext> jaxbContexts;
    private final Map<Class, QualifyingPropertyDataToXmlConverter<TXml>> converters;
    private final String propsElemName;

    protected BaseJAXBMarshaller(int convertersInitialSize, String propsElemName) {
        this.converters = new HashMap<Class, QualifyingPropertyDataToXmlConverter<TXml>>(convertersInitialSize);
        this.propsElemName = propsElemName;
    }

    protected void putConverter(Class<? extends PropertyDataObject> propClass, QualifyingPropertyDataToXmlConverter<TXml> propConverter) {
        this.converters.put(propClass, propConverter);
    }

    protected void doMarshal(SigAndDataObjsPropertiesData properties, Node qualifyingPropsNode, TXml xmlProps) throws MarshalException {
        if (properties.isEmpty()) {
            return;
        }
        Document doc = qualifyingPropsNode.getOwnerDocument();
        Collection<PropertyDataObject> unknownSigProps = null;
        if (!properties.getSigProps().isEmpty()) {
            this.prepareSigProps(xmlProps);
            unknownSigProps = this.convert(properties.getSigProps(), xmlProps, doc);
        }
        Collection<PropertyDataObject> unknownDataObjProps = null;
        if (!properties.getDataObjProps().isEmpty()) {
            this.prepareDataObjsProps(xmlProps);
            unknownDataObjProps = this.convert(properties.getDataObjProps(), xmlProps, doc);
        }
        if (this.propsNotAlreadyPresent(qualifyingPropsNode)) {
            this.doJAXBMarshalling(qualifyingPropsNode, xmlProps);
        } else {
            Element tempNode = DOMHelper.createElement(qualifyingPropsNode.getOwnerDocument(), "temp", null, "http://uri.etsi.org/01903/v1.3.2#");
            qualifyingPropsNode.appendChild(tempNode);
            this.doJAXBMarshalling(tempNode, xmlProps);
            qualifyingPropsNode.removeChild(tempNode);
            this.transferProperties(qualifyingPropsNode, tempNode);
        }
        Element topMostPropsElem = DOMHelper.getFirstDescendant((Element)qualifyingPropsNode, "http://uri.etsi.org/01903/v1.3.2#", this.propsElemName);
        if (!CollectionUtils.nullOrEmpty(unknownSigProps)) {
            this.marshallUnknownProps(unknownSigProps, DOMHelper.getFirstChildElement(topMostPropsElem));
        }
        if (!CollectionUtils.nullOrEmpty(unknownDataObjProps)) {
            this.marshallUnknownProps(unknownDataObjProps, DOMHelper.getLastChildElement(topMostPropsElem));
        }
    }

    private Collection<PropertyDataObject> convert(Collection<PropertyDataObject> props, TXml xmlProps, Document doc) throws MarshalException {
        Collection unknownProps = null;
        for (PropertyDataObject p : props) {
            QualifyingPropertyDataToXmlConverter<TXml> conv = this.converters.get(p.getClass());
            if (null == conv) {
                unknownProps = CollectionUtils.newIfNull(unknownProps, 1);
                unknownProps.add(p);
                continue;
            }
            conv.convertIntoObjectTree(p, xmlProps, doc);
        }
        return unknownProps;
    }

    private boolean propsNotAlreadyPresent(Node qualifyingPropsNode) {
        return null == DOMHelper.getFirstDescendant((Element)qualifyingPropsNode, "http://uri.etsi.org/01903/v1.3.2#", this.propsElemName);
    }

    private void doJAXBMarshalling(Node qualifyingPropsNode, TXml xmlProps) throws MarshalException {
        try {
            JAXBContext jaxbContext = jaxbContexts.get(xmlProps.getClass());
            Marshaller marshaller = jaxbContext.createMarshaller();
            Object propsElem = this.createPropsXmlElem(new ObjectFactory(), xmlProps);
            marshaller.marshal(propsElem, qualifyingPropsNode);
        }
        catch (JAXBException ex) {
            throw new MarshalException("Error on JAXB marshalling", ex);
        }
    }

    private void transferProperties(Node qualifPropsNode, Node tempNode) {
        Element existingProps = DOMHelper.getFirstDescendant((Element)qualifPropsNode, "http://uri.etsi.org/01903/v1.3.2#", this.propsElemName);
        Element newProps = DOMHelper.getFirstChildElement(tempNode);
        Element newSpecificProps = DOMHelper.getFirstChildElement(newProps);
        do {
            Element existingSpecificProps;
            if (null == (existingSpecificProps = DOMHelper.getFirstDescendant(existingProps, newSpecificProps.getNamespaceURI(), newSpecificProps.getLocalName()))) {
                existingProps.appendChild(newSpecificProps);
                continue;
            }
            this.transferChildren(newSpecificProps, existingSpecificProps);
        } while ((newSpecificProps = DOMHelper.getNextSiblingElement(newSpecificProps)) != null);
    }

    private void transferChildren(Element from, Element to) {
        Node child = from.getFirstChild();
        while (child != null) {
            Node childSib = child.getNextSibling();
            to.appendChild(child);
            child = childSib;
        }
    }

    private void marshallUnknownProps(Collection<PropertyDataObject> unknownProps, Element parent) throws MarshalException {
        for (PropertyDataObject pData : unknownProps) {
            if (!(pData instanceof GenericDOMData)) {
                throw new UnsupportedDataObjectException(pData);
            }
            Node propElem = ((GenericDOMData)pData).getPropertyElement();
            if (propElem.getOwnerDocument() != parent.getOwnerDocument()) {
                propElem = parent.getOwnerDocument().importNode(propElem, true);
            }
            parent.appendChild(propElem);
        }
    }

    protected abstract void prepareSigProps(TXml var1);

    protected abstract void prepareDataObjsProps(TXml var1);

    protected abstract Object createPropsXmlElem(ObjectFactory var1, TXml var2);

    static {
        try {
            HashMap<Class, JAXBContext> contexts = new HashMap<Class, JAXBContext>();
            contexts.put(XmlSignedPropertiesType.class, JAXBContext.newInstance((Class[])new Class[]{XmlSignedPropertiesType.class}));
            contexts.put(XmlUnsignedPropertiesType.class, JAXBContext.newInstance((Class[])new Class[]{XmlUnsignedPropertiesType.class}));
            jaxbContexts = Collections.unmodifiableMap(contexts);
        }
        catch (JAXBException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

