/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.cert;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.cert.RevokedCertificateException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class OcspHelper {
    private static final Log LOG = LogFactory.getLog(OcspHelper.class);
    private final X509Certificate issuerCertificate;
    private final Date signDate;
    private final X509Certificate certificateToCheck;
    private final Set<X509Certificate> additionalCerts;
    private final String ocspUrl;
    private DEROctetString encodedNonce;
    private X509Certificate ocspResponderCertificate;
    private final JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();

    public OcspHelper(X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, Set<X509Certificate> set, String string) {
        this.certificateToCheck = x509Certificate;
        this.signDate = date;
        this.issuerCertificate = x509Certificate2;
        this.additionalCerts = set;
        this.ocspUrl = string;
    }

    public OCSPResp getResponseOcsp() throws IOException, OCSPException, RevokedCertificateException {
        OCSPResp oCSPResp = this.performRequest();
        this.verifyOcspResponse(oCSPResp);
        return oCSPResp;
    }

    public X509Certificate getOcspResponderCertificate() {
        return this.ocspResponderCertificate;
    }

    private void verifyOcspResponse(OCSPResp oCSPResp) throws OCSPException, RevokedCertificateException, IOException {
        this.verifyRespStatus(oCSPResp);
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)oCSPResp.getResponseObject();
        if (basicOCSPResp != null) {
            ResponderID responderID = basicOCSPResp.getResponderId().toASN1Primitive();
            X500Name x500Name = responderID.getName();
            if (x500Name != null) {
                this.findResponderCertificateByName(basicOCSPResp, x500Name);
            } else {
                byte[] byArray = responderID.getKeyHash();
                if (byArray != null) {
                    this.findResponderCertificateByKeyHash(basicOCSPResp, byArray);
                } else {
                    throw new OCSPException("OCSP: basic response must provide name or key hash");
                }
            }
            if (this.ocspResponderCertificate == null) {
                throw new OCSPException("OCSP: certificate for responder " + x500Name + " not found");
            }
            try {
                SigUtils.checkResponderCertificateUsage(this.ocspResponderCertificate);
            }
            catch (CertificateParsingException certificateParsingException) {
                LOG.error((Object)certificateParsingException, (Throwable)certificateParsingException);
            }
            this.checkOcspSignature(this.ocspResponderCertificate, basicOCSPResp);
            boolean bl = this.checkNonce(basicOCSPResp);
            SingleResp[] singleRespArray = basicOCSPResp.getResponses();
            if (singleRespArray.length != 1) {
                throw new OCSPException("OCSP: Received " + singleRespArray.length + " responses instead of 1!");
            }
            SingleResp singleResp = singleRespArray[0];
            CertificateStatus certificateStatus = singleResp.getCertStatus();
            if (!bl) {
                this.checkOcspResponseFresh(singleResp);
            }
            if (certificateStatus instanceof RevokedStatus) {
                RevokedStatus revokedStatus = (RevokedStatus)certificateStatus;
                if (revokedStatus.getRevocationTime().compareTo(this.signDate) <= 0) {
                    throw new RevokedCertificateException("OCSP: Certificate is revoked since " + revokedStatus.getRevocationTime(), revokedStatus.getRevocationTime());
                }
                LOG.info((Object)("The certificate was revoked after signing by OCSP " + this.ocspUrl + " on " + revokedStatus.getRevocationTime()));
            } else if (certificateStatus != CertificateStatus.GOOD) {
                throw new OCSPException("OCSP: Status of Cert is unknown");
            }
        }
    }

    private byte[] getKeyHashFromCertHolder(X509CertificateHolder x509CertificateHolder) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateHolder.getSubjectPublicKeyInfo();
        try {
            return MessageDigest.getInstance("SHA-1").digest(subjectPublicKeyInfo.getPublicKeyData().getBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)"SHA-1 Algorithm not found", (Throwable)noSuchAlgorithmException);
            return new byte[0];
        }
    }

    private void findResponderCertificateByKeyHash(BasicOCSPResp basicOCSPResp, byte[] byArray) throws IOException {
        X509CertificateHolder[] x509CertificateHolderArray = basicOCSPResp.getCerts();
        for (X509CertificateHolder x509CertificateHolder : x509CertificateHolderArray) {
            byte[] byArray2 = this.getKeyHashFromCertHolder(x509CertificateHolder);
            if (!Arrays.equals(byArray, byArray2)) continue;
            try {
                this.ocspResponderCertificate = this.certificateConverter.getCertificate(x509CertificateHolder);
                return;
            }
            catch (CertificateException certificateException) {
                LOG.error((Object)certificateException, (Throwable)certificateException);
                break;
            }
        }
        for (X509Certificate x509Certificate : this.additionalCerts) {
            try {
                byte[] byArray3 = this.getKeyHashFromCertHolder(new X509CertificateHolder(x509Certificate.getEncoded()));
                if (!Arrays.equals(byArray, byArray3)) continue;
                this.ocspResponderCertificate = x509Certificate;
                return;
            }
            catch (CertificateException certificateException) {
                LOG.error((Object)certificateException, (Throwable)certificateException);
            }
        }
    }

    private void findResponderCertificateByName(BasicOCSPResp basicOCSPResp, X500Name x500Name) {
        X509CertificateHolder[] x509CertificateHolderArray = basicOCSPResp.getCerts();
        for (X509CertificateHolder x509CertificateHolder : x509CertificateHolderArray) {
            if (!x500Name.equals((Object)x509CertificateHolder.getSubject())) continue;
            try {
                this.ocspResponderCertificate = this.certificateConverter.getCertificate(x509CertificateHolder);
                return;
            }
            catch (CertificateException certificateException) {
                LOG.error((Object)certificateException, (Throwable)certificateException);
            }
        }
        for (X509Certificate x509Certificate : this.additionalCerts) {
            X500Name x500Name2 = new X500Name(x509Certificate.getSubjectX500Principal().getName());
            if (!x500Name2.equals((Object)x500Name)) continue;
            this.ocspResponderCertificate = x509Certificate;
            return;
        }
    }

    private void checkOcspResponseFresh(SingleResp singleResp) throws OCSPException {
        Date date = Calendar.getInstance().getTime();
        Date date2 = singleResp.getThisUpdate();
        if (date2 == null) {
            throw new OCSPException("OCSP: thisUpdate field is missing in response (RFC 5019 2.2.4.)");
        }
        Date date3 = singleResp.getNextUpdate();
        if (date3 == null) {
            throw new OCSPException("OCSP: nextUpdate field is missing in response (RFC 5019 2.2.4.)");
        }
        if (date.compareTo(date2) < 0) {
            LOG.error((Object)(date + " < " + date2));
            throw new OCSPException("OCSP: current date < thisUpdate field (RFC 5019 2.2.4.)");
        }
        if (date.compareTo(date3) > 0) {
            LOG.error((Object)(date + " > " + date3));
            throw new OCSPException("OCSP: current date > nextUpdate field (RFC 5019 2.2.4.)");
        }
        LOG.info((Object)"OCSP response is fresh");
    }

    private void checkOcspSignature(X509Certificate x509Certificate, BasicOCSPResp basicOCSPResp) throws OCSPException, IOException {
        try {
            ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider(SecurityProvider.getProvider()).build(x509Certificate);
            if (!basicOCSPResp.isSignatureValid(contentVerifierProvider)) {
                throw new OCSPException("OCSP-Signature is not valid!");
            }
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new OCSPException("Error checking Ocsp-Signature", (Throwable)operatorCreationException);
        }
    }

    private boolean checkNonce(BasicOCSPResp basicOCSPResp) throws OCSPException {
        Extension extension = basicOCSPResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (extension != null) {
            DEROctetString dEROctetString = (DEROctetString)extension.getExtnValue();
            if (!dEROctetString.equals((Object)this.encodedNonce)) {
                throw new OCSPException("Different nonce found in response!");
            }
            LOG.info((Object)"Nonce is good");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCSPResp performRequest() throws IOException, OCSPException {
        OCSPReq oCSPReq = this.generateOCSPRequest();
        URL uRL = new URL(this.ocspUrl);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        try {
            OCSPResp oCSPResp;
            httpURLConnection.setRequestProperty("Content-Type", "application/ocsp-request");
            httpURLConnection.setRequestProperty("Accept", "application/ocsp-response");
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            try {
                outputStream.write(oCSPReq.getEncoded());
            }
            finally {
                IOUtils.closeQuietly((Closeable)outputStream);
            }
            if (httpURLConnection.getResponseCode() != 200) {
                throw new IOException("OCSP: Could not access url, ResponseCode: " + httpURLConnection.getResponseCode());
            }
            InputStream inputStream = (InputStream)httpURLConnection.getContent();
            try {
                oCSPResp = new OCSPResp(inputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable)inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)inputStream);
            return oCSPResp;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public void verifyRespStatus(OCSPResp oCSPResp) throws OCSPException {
        String string = "";
        if (oCSPResp != null) {
            int n = oCSPResp.getStatus();
            switch (n) {
                case 2: {
                    string = "INTERNAL_ERROR";
                    LOG.error((Object)"An internal error occurred in the OCSP Server!");
                    break;
                }
                case 1: {
                    string = "MALFORMED_REQUEST";
                    LOG.error((Object)"Your request did not fit the RFC 2560 syntax!");
                    break;
                }
                case 5: {
                    string = "SIG_REQUIRED";
                    LOG.error((Object)"Your request was not signed!");
                    break;
                }
                case 3: {
                    string = "TRY_LATER";
                    LOG.error((Object)"The server was too busy to answer you!");
                    break;
                }
                case 6: {
                    string = "UNAUTHORIZED";
                    LOG.error((Object)"The server could not authenticate you!");
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    string = "UNKNOWN";
                    LOG.error((Object)("Unknown OCSPResponse status code! " + n));
                }
            }
        }
        if (oCSPResp == null || oCSPResp.getStatus() != 0) {
            throw new OCSPException("OCSP response unsuccessful, status: " + string);
        }
    }

    private OCSPReq generateOCSPRequest() throws OCSPException, IOException {
        CertificateID certificateID;
        Security.addProvider(SecurityProvider.getProvider());
        try {
            certificateID = new CertificateID((DigestCalculator)new SHA1DigestCalculator(), (X509CertificateHolder)new JcaX509CertificateHolder(this.issuerCertificate), this.certificateToCheck.getSerialNumber());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException("Error creating CertificateID with the Certificate encoding", certificateEncodingException);
        }
        Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_response, false, new DLSequence((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic).getEncoded());
        Random random = new Random();
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        this.encodedNonce = new DEROctetString((ASN1Encodable)new DEROctetString(byArray));
        Extension extension2 = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)this.encodedNonce);
        OCSPReqBuilder oCSPReqBuilder = new OCSPReqBuilder();
        oCSPReqBuilder.setRequestExtensions(new Extensions(new Extension[]{extension, extension2}));
        oCSPReqBuilder.addRequest(certificateID);
        return oCSPReqBuilder.build();
    }

    private static class SHA1DigestCalculator
    implements DigestCalculator {
        private final ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private SHA1DigestCalculator() {
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }

        public OutputStream getOutputStream() {
            return this.bOut;
        }

        public byte[] getDigest() {
            byte[] byArray = this.bOut.toByteArray();
            this.bOut.reset();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                return messageDigest.digest(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOG.error((Object)"SHA-1 Algorithm not found", (Throwable)noSuchAlgorithmException);
                return new byte[0];
            }
        }
    }
}

