/* ISC license. */

#include <stddef.h>
#include <stdint.h>
#include <limits.h>
#include <errno.h>

#include <skalibs/uint64.h>
#include <skalibs/bytestr.h>
#include <skalibs/stralloc.h>

#include <execline/execline.h>

int el_parse (stralloc *sa, el_chargen_func_ref next, void *source)
{
  static unsigned char const class[256] = "`aaaaaaaaadaaaaaaaaaaaaaaaaaaaaaafcbffffffffffffjhhhhhhhiifffffffmmmmmmfffffffffffffffffffffeffffggmmmgfffffffkfffkfkfkflffnfoffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff" ;
  static uint16_t const table[17][16] =
  {
    { 0x0011, 0x0000, 0x0001, 0x2008, 0x0000, 0x0005, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2402, 0x2403 },
    { 0x0011, 0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001 },
    { 0x0012, 0x1000, 0x0404, 0x0008, 0x1000, 0x0005, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404 },
    { 0x0911, 0x0900, 0x0404, 0x0008, 0x0900, 0x0005, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404 },
    { 0x0111, 0x0100, 0x0404, 0x0008, 0x0100, 0x0006, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404 },
    { 0x0011, 0x2404, 0x2404, 0x2404, 0x0000, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404, 0x2404 },
    { 0x0012, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404, 0x0404 },
    { 0x0012, 0x0408, 0x0408, 0x0408, 0x0008, 0x0408, 0x0408, 0x0208, 0x448c, 0x448c, 0x0089, 0x0208, 0x0408, 0x0408, 0x0408, 0x0408 },
    { 0x0012, 0x0408, 0x0408, 0x0004, 0x0408, 0x0007, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408 },
    { 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x440a, 0x0012, 0x440a, 0x0012, 0x008e, 0x0012, 0x0012, 0x0012 },
    { 0x8111, 0x8408, 0x8408, 0x8004, 0x8408, 0x8007, 0x8408, 0x8408, 0x040b, 0x8408, 0x040b, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408 },
    { 0x8111, 0x8408, 0x8408, 0x8004, 0x8408, 0x8007, 0x8408, 0x8408, 0x0410, 0x8408, 0x0410, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408 },
    { 0x8111, 0x8408, 0x8408, 0x8004, 0x8408, 0x8007, 0x8408, 0x8408, 0x040d, 0x040d, 0x040d, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408 },
    { 0x8111, 0x8408, 0x8408, 0x8004, 0x8408, 0x8007, 0x8408, 0x8408, 0x0410, 0x0410, 0x0410, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408 },
    { 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x440f, 0x440f, 0x440f, 0x440f, 0x0012, 0x0012, 0x440f, 0x0012, 0x0012 },
    { 0x8111, 0x8408, 0x8408, 0x8004, 0x8408, 0x8007, 0x8408, 0x0410, 0x0410, 0x0410, 0x0410, 0x8408, 0x8408, 0x0410, 0x8408, 0x8408 },
    { 0x8111, 0x8408, 0x8408, 0x8004, 0x8408, 0x8007, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408, 0x8408 }
  } ;

  size_t mark = 0 ;
  unsigned int n = 0, blevel = 0 ;
  uint8_t state = 0, base = 10 ;

  while (state < 0x11)
  {
    uint16_t c ;
    unsigned char cur ;
    if (!(*next)(&cur, source)) return -1 ;
    c = table[state][class[cur]-'`'] ;
    state = c & 0x1F ;

    if (c & 0x8000U)
    {
      uint64_t u ;
      if (!stralloc_0(sa)) return -1 ;
      sa->len = mark ;
      uint64_scan_base(sa->s + sa->len, &u, base) ;
      if (!u || u > 0xff) return -2 ;
      sa->s[sa->len++] = (unsigned char)u ;
    }
    if (c & 0x4000U) mark = sa->len ;
    if (c & 0x2000U)
    {
      unsigned int i = blevel ;
      if (!stralloc_readyplus(sa, i<<2)) return -1 ;
      while (i--) sa->s[sa->len++] = ' ' ;
    }
    if (c & 0x1000U) sa->len -= ++blevel ;
    if (c & 0x0800U)
    {
      if (!blevel--) return -4 ;
      sa->len -= 2 ;
    }
    if (c & 0x0400U) if (!stralloc_catb(sa, (char *)&cur, 1)) return -1 ;
    if (c & 0x0200U)
    {
      char x = 7 + byte_chr("abtnvfr", 7, cur) ;
      if (!stralloc_catb(sa, &x, 1)) return -1 ;
    }
    if (c & 0x0100U)
    {
      if (n++ >= INT_MAX) return (errno = E2BIG, -1) ;
      if (!stralloc_0(sa)) return -1 ;
    }
    if (c & 0x0080U)
    {
      switch (cur)
      {
        case 'x' : base = 16 ; break ;
        case '0' : base = 8 ; break ;
        default : base = 10 ;
      }
    }
  }

  if (state > 0x11) return -2 ;
  if (blevel) return -3 ;
  return n ;
}
