/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Year;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiParameter;

public class DotNetAPIGenerator
extends AbstractAPIGenerator {
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-dotnet/src/OWASPZAPDotNetAPI/OWASPZAPDotNetAPI/Generated";
    private static final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright " + Year.now() + " the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n";
    private static final Map<String, String> nameMap;

    public DotNetAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public DotNetAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    public DotNetAPIGenerator(String path, boolean optional, ResourceBundle resourceBundle) {
        super(path, optional, resourceBundle);
    }

    private void generateCSharpElement(ApiElement element, String component, String type, Writer out) throws IOException {
        String name;
        boolean hasParams;
        block23: {
            hasParams = false;
            String descTag = element.getDescriptionTag();
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("\t\t/// <summary>\n");
                out.write("\t\t///" + desc + "\n");
                if (this.isOptional()) {
                    out.write("\t\t///This component is optional and therefore the API will only work if it is installed\n");
                }
                if (element.isDeprecated()) {
                    out.write("\t\t/// [Obsolete]");
                    String deprecationDesc = element.getDeprecatedDescription();
                    if (deprecationDesc != null && !deprecationDesc.isEmpty()) {
                        out.write(" " + deprecationDesc);
                    }
                    out.write("\n");
                }
                out.write("\t\t/// </summary>\n");
                out.write("\t\t/// <returns></returns>\n");
            }
            catch (Exception e) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block23;
                out.write("\t\t/// <summary>\n");
                out.write("\t\t///This component is optional and therefore the API will only work if it is installed\n");
                out.write("\t\t/// </summary>\n");
                out.write("\t\t/// <returns></returns>\n");
            }
        }
        if (element.isDeprecated()) {
            String deprecationDesc = element.getDeprecatedDescription();
            if (deprecationDesc != null && !deprecationDesc.isEmpty()) {
                out.write("\t\t[Obsolete(\"");
                out.write(deprecationDesc);
                out.write("\")]\n");
            } else {
                out.write("\t\t[Obsolete]\n");
            }
        }
        if (type.equals("other")) {
            out.write("\t\tpublic byte[] " + DotNetAPIGenerator.createMethodName(element.getName()) + "(");
        } else {
            out.write("\t\tpublic IApiResponse " + DotNetAPIGenerator.createMethodName(element.getName()) + "(");
        }
        for (ApiParameter parameter : element.getParameters()) {
            if (!hasParams) {
                hasParams = true;
            } else {
                out.write(", ");
            }
            name = parameter.getName();
            if (name.equalsIgnoreCase("boolean")) {
                out.write("bool boolean");
                continue;
            }
            if (name.equalsIgnoreCase("integer")) {
                out.write("int i");
                continue;
            }
            out.write("string ");
            out.write(DotNetAPIGenerator.createParameterName(name));
        }
        out.write(")\n\t\t{\n");
        out.write("\t\t\tDictionary<string, string> parameters = null;\n");
        if (hasParams) {
            out.write("\t\t\tparameters = new Dictionary<string, string>();\n");
            for (ApiParameter parameter : element.getParameters()) {
                name = parameter.getName();
                out.write("\t\t\tparameters.Add(\"" + name + "\", ");
                if (name.equalsIgnoreCase("boolean")) {
                    out.write("Convert.ToString(boolean)");
                } else if (name.equalsIgnoreCase("integer")) {
                    out.write("Convert.ToString(i)");
                } else {
                    out.write(DotNetAPIGenerator.createParameterName(name));
                }
                out.write(");\n");
            }
        }
        if (type.equals("other")) {
            out.write("\t\t\treturn this.api.CallApiOther(\"" + component + "\", \"" + type + "\", \"" + element.getName() + "\", parameters);\n");
        } else {
            out.write("\t\t\treturn this.api.CallApi(\"" + component + "\", \"" + type + "\", \"" + element.getName() + "\", parameters);\n");
        }
        out.write("\t\t}\n\n");
    }

    private static String createMethodName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return DotNetAPIGenerator.removeAllFullStopCharacters(name);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private static String createParameterName(String paramName) {
        String name = paramName.toLowerCase(Locale.ROOT);
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return DotNetAPIGenerator.removeAllFullStopCharacters(name);
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        String className = imp.getPrefix().substring(0, 1).toUpperCase() + imp.getPrefix().substring(1);
        Path file = this.getDirectory().resolve(className + ".cs");
        System.out.println("Generating " + file.toAbsolutePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(HEADER);
            out.write("\n\n");
            out.write("using System;\n");
            out.write("using System.Collections.Generic;\n");
            out.write("using System.Text;\n");
            out.write("\n");
            out.write("\n");
            out.write("/*\n");
            out.write(" * This file was automatically generated.\n");
            out.write(" */\n");
            out.write("namespace OWASPZAPDotNetAPI.Generated\n");
            out.write("{\n");
            out.write("\tpublic class " + className + " \n\t{");
            out.write("\n\t\tprivate ClientApi api = null;\n\n");
            out.write("\t\tpublic " + className + "(ClientApi api) \n\t\t{\n");
            out.write("\t\t\tthis.api = api;\n");
            out.write("\t\t}\n\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generateCSharpElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generateCSharpElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generateCSharpElement(apiElement, imp.getPrefix(), "other", out);
            }
            out.write("\t}\n");
            out.write("}\n");
        }
    }

    public static void main(String[] args) throws Exception {
        DotNetAPIGenerator dnapi = new DotNetAPIGenerator(DEFAULT_OUTPUT_DIR, false);
        dnapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        initMap.put("string", "str");
        initMap.put("params", "parameters");
        initMap.put("bool", "boolean");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

