/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.CalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.officelaf.SpinningCalendarHeaderHandler;

public class OfficeMonthViewUI
extends BasicMonthViewUI {
    private static final Color FLAGGED_BACKGROUND = UIManager.getLookAndFeelDefaults().getColor("JXMonthView.flaggedDayBackground");

    public static ComponentUI createUI(JComponent b) {
        return new OfficeMonthViewUI();
    }

    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    protected void paintMonthHeader(Graphics g, Calendar month) {
        super.paintMonthHeader(g, month);
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected CalendarRenderingHandler createRenderingHandler() {
        return new customRenderingHandler();
    }

    protected void installComponents() {
        super.installComponents();
    }

    protected void uninstallComponents() {
        super.uninstallComponents();
    }

    protected CalendarHeaderHandler createCalendarHeaderHandler() {
        return new SpinningCalendarHeaderHandler();
    }

    protected CalendarHeaderHandler getCalendarHeaderHandler() {
        return super.getCalendarHeaderHandler();
    }

    protected void setCalendarHeaderHandler(CalendarHeaderHandler calendarHeaderHandler) {
        super.setCalendarHeaderHandler(calendarHeaderHandler);
    }

    private class customRenderingHandler
    extends BasicMonthViewUI.RenderingHandler {
        private customRenderingHandler() {
        }

        public JComponent prepareRenderingComponent(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
            JComponent rc = super.prepareRenderingComponent(monthView, calendar, dayState);
            Date dateToDraw = calendar.getTime();
            if (monthView.isFlaggedDate(dateToDraw) && !monthView.isSelected(dateToDraw) && !monthView.isUnselectableDate(dateToDraw) && (dayState.equals((Object)CalendarState.IN_MONTH) || dayState.equals((Object)CalendarState.TODAY))) {
                rc.setBackground(FLAGGED_BACKGROUND);
            }
            return rc;
        }
    }
}

