/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.editor;

import com.paterva.maltego.automation.view.editor.MachineEditorControl;
import com.paterva.maltego.automation.view.editor.TasNode;
import com.paterva.maltego.automation.view.editor.TransformFilterUtils;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

class AllTasesChildFactory
extends ChildFactory<TransformServerInfo> {
    private final MachineEditorControl _machineEditControl;
    public static final String TAS_WAIT_STRING = "Getting TAS information...";

    public AllTasesChildFactory(MachineEditorControl control) {
        this._machineEditControl = control;
    }

    protected boolean createKeys(List<TransformServerInfo> toFill) {
        String selectedType = TransformFilterUtils.getSelectedType(this._machineEditControl.getSelectedOption());
        TransformServerRegistry registry = TransformServerRegistry.getDefault();
        for (TransformServerInfo tas : registry.getAll()) {
            List<TransformDefinition> transforms;
            if (!tas.isEnabled() || (transforms = TransformFilterUtils.getTransforms(tas, selectedType)).isEmpty()) continue;
            toFill.add(tas);
        }
        Collections.sort(toFill, new Comparator<TransformServerInfo>(){

            @Override
            public int compare(TransformServerInfo o1, TransformServerInfo o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return true;
    }

    protected Node createNodeForKey(TransformServerInfo key) {
        TasNode tasNode = new TasNode(key, this._machineEditControl);
        return tasNode;
    }

    protected Node createWaitNode() {
        AbstractNode wait = new AbstractNode(Children.LEAF);
        wait.setDisplayName(TAS_WAIT_STRING);
        return wait;
    }
}

