/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.error.reporting.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.paterva.maltego.error.reporting.ui.ProblemDto;
import com.paterva.maltego.licensing.rest.C;
import com.paterva.maltego.util.ExceptionUtilities;
import com.paterva.maltego.util.ui.problemreport.settings.ProblemReportOptions;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ProblemDtoBuilder {
    private final ProblemDto problemDto = new ProblemDto();
    private boolean userIntervened = false;

    public ProblemDtoBuilder setEmail(String email) {
        this.problemDto.setEmail(email);
        return this;
    }

    public ProblemDtoBuilder setMessage(String message) {
        this.problemDto.setErrorMessage(message);
        return this;
    }

    public static String getFormattedDate(ProblemDto problemDto) {
        return DateTimeFormatter.ISO_INSTANT.format(problemDto.getDateReported());
    }

    public ProblemDtoBuilder setMessage(Throwable throwable) {
        this.setMessage(ExceptionUtilities.toDescriptiveOneLiner((Throwable)throwable));
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        this.problemDto.setStackTrace(stackTrace.replace("\r", ""));
        return this;
    }

    public ProblemDtoBuilder setDescription(String description) {
        this.problemDto.setDescription(description);
        return this;
    }

    public ProblemDto build() {
        this.validate();
        this.problemDto.setDateReported(Instant.now());
        this.problemDto.setMachineHash(ProblemReportOptions.getDefault().getMachineIdHash());
        Map infoMap = C.A();
        this.problemDto.setMaltegoProduct((String)infoMap.get("ProductName"));
        this.problemDto.setMaltegoVersion((String)infoMap.get("Version"));
        this.problemDto.setMaltegoOEM((String)infoMap.get("OEM"));
        this.problemDto.setLicenseMode((String)infoMap.get("LicenseMode"));
        this.problemDto.setOsArch((String)infoMap.get("PlatformArch"));
        this.problemDto.setOsName((String)infoMap.get("PlatformName"));
        this.problemDto.setOsVersion((String)infoMap.get("PlatformVersion"));
        this.problemDto.setJavaVersion((String)infoMap.get("JavaVersion"));
        return this.problemDto;
    }

    public String buildJsonString() throws JsonProcessingException {
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.registerModule((Module)new JavaTimeModule());
        jsonMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return jsonMapper.writeValueAsString((Object)this.build());
    }

    public void userIntervened() {
        this.userIntervened = true;
    }

    public boolean hasUserIntervened() {
        return this.userIntervened;
    }

    private void validate() {
        if (this.problemDto.getErrorMessage() == null) {
            throw new RuntimeException("Message not set");
        }
    }
}

