/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.CloudGraphRegistry;
import com.maltego.cloud.CloudSave;
import com.paterva.maltego.archive.mtz.GraphFileFilter;
import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.imgfactory.serialization.ImageCacheSerializer;
import com.paterva.maltego.ui.graph.analytics.SaveGraphEvent;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.data.GraphOpenSupport;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.ui.graph.data.RecentFiles;
import com.paterva.maltego.ui.graph.data.SaveAsCapable;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class GraphEditorSupport
extends GraphOpenSupport
implements SaveAsCapable {
    private static final Logger LOG = Logger.getLogger(GraphEditorSupport.class.getName());

    public GraphEditorSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public void updateHTMLTitle(String title) {
        if (!this.allEditors.isEmpty()) {
            this.updateHTMLTitle(title, this.allEditors.getComponents());
        }
    }

    private void updateHTMLTitle(final String title, final Enumeration<CloneableTopComponent> editors) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (editors.hasMoreElements()) {
                    CloneableTopComponent tc = (CloneableTopComponent)editors.nextElement();
                    tc.setHtmlDisplayName(title);
                }
            }
        });
    }

    protected GraphID getSaveProxy() {
        return this.getGraphDataObject().getGraphID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws IOException {
        boolean continueSaveToDisk;
        GraphDataObject dataObj;
        block13: {
            CloudGraphRegistry cloudGraphRegistry;
            GraphID maltegoGraphID;
            block15: {
                boolean saveInEDT;
                block16: {
                    dataObj = this.getGraphDataObject();
                    if (!dataObj.isModified()) {
                        return;
                    }
                    continueSaveToDisk = false;
                    maltegoGraphID = this.getSaveProxy();
                    cloudGraphRegistry = CloudGraphRegistry.getDefault();
                    saveInEDT = "true".equals(System.getProperty("maltego.closeApp.setSaveInEDT", "false"));
                    CloudAuth cloudAuth = CloudAuth.getDefault();
                    if (!cloudAuth.isCloudAuthEnabled()) break block15;
                    if (!cloudGraphRegistry.isCloudGraph(maltegoGraphID)) break block16;
                    if (cloudGraphRegistry.isEditable(maltegoGraphID)) {
                        CloudSave cloudSave = (CloudSave)Lookup.getDefault().lookup(CloudSave.class);
                        cloudSave.save(maltegoGraphID, saveInEDT);
                        return;
                    }
                    continueSaveToDisk = this.showSaveToDiskDialog(dataObj.getName(), "Read Only Graph", " was opened as Read Only!\n");
                    if (!continueSaveToDisk) {
                        return;
                    }
                    break block13;
                }
                if (cloudGraphRegistry.isVersionOfCloudGraph(maltegoGraphID)) {
                    if (cloudGraphRegistry.isVersionOfCloudGraphSupported(maltegoGraphID)) {
                        Boolean saveToDisk = this.showSaveToDiskOrCloudDialog(dataObj.getName());
                        if (Boolean.TRUE.equals(saveToDisk)) {
                            continueSaveToDisk = true;
                            break block13;
                        } else {
                            if (!Boolean.FALSE.equals(saveToDisk)) return;
                            CloudSave cloudSave = (CloudSave)Lookup.getDefault().lookup(CloudSave.class);
                            cloudSave.save(maltegoGraphID, saveInEDT);
                            return;
                        }
                    }
                    continueSaveToDisk = this.showSaveToDiskDialog(dataObj.getName(), "Graph Version Mismatch \u203a Read Only Graph", " was opened as Read Only after a graph schema version mismatch, therefore cannot be saved to the Cloud since this version of Maltego Graph (Desktop) does not support necessary cloud graph features.\n", "\nSome graph features may be missing compared to the cloud graph.\n");
                    if (!continueSaveToDisk) {
                        return;
                    }
                }
                break block13;
            }
            if (cloudGraphRegistry.isCloudGraph(maltegoGraphID) ? (cloudGraphRegistry.isEditable(maltegoGraphID) ? !(continueSaveToDisk = this.showSaveToDiskDialog(dataObj.getName(), "Not in Maltego Beta program", " cannot be saved to the Cloud\nsince the feature is only available on the Maltego Beta program.\n")) : !(continueSaveToDisk = this.showSaveToDiskDialog(dataObj.getName(), "Read Only Graph", " was opened as Read Only!\n"))) : cloudGraphRegistry.isVersionOfCloudGraph(maltegoGraphID) && !(continueSaveToDisk = this.showSaveToDiskDialog(dataObj.getName(), "Read Only Graph", " was opened as Read Only!\n"))) {
                return;
            }
        }
        FileObject fo = dataObj.getPrimaryFile();
        File file = new File(fo.getPath());
        boolean save = true;
        if (!file.isAbsolute() || continueSaveToDisk) {
            FileOptions fileOptions = this.showSaveAsDialog(dataObj);
            if (fileOptions == null) return;
            try {
                WindowUtil.showWaitCursor();
                dataObj.setPassword(fileOptions.getPassword());
                dataObj.setFileType(fileOptions.getGraphFileType());
                this.movePrimaryFile(fileOptions);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
        if (!save) return;
        this.saveImpl(dataObj);
    }

    protected String savedMessage(DataObject dobj) {
        return "Saved " + dobj.getPrimaryFile().getName();
    }

    @Override
    public void saveAs() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GraphDataObject dataObj = GraphEditorSupport.this.getGraphDataObject();
                String oldName = dataObj.getName();
                FileObject oldParent = dataObj.getPrimaryFile().getParent();
                GraphFileType oldFileType = dataObj.getFileType();
                FileOptions fileOptions = GraphEditorSupport.this.showSaveAsDialog(dataObj);
                if (fileOptions != null) {
                    try {
                        WindowUtil.showWaitCursor();
                        String newName = fileOptions.getFilename().replaceFirst("\\.[^.]+$", "");
                        GraphFileType newFileType = fileOptions.getGraphFileType();
                        CloudGraphRegistry registry = CloudGraphRegistry.getDefault();
                        GraphID graphID = dataObj.getGraphID();
                        if (registry.isCloudGraph(graphID) || registry.isVersionOfCloudGraph(graphID)) {
                            GraphEditorSupport.this.saveCloudGraphAsLocalGraph(dataObj, fileOptions, newFileType, newName);
                        } else {
                            dataObj.setFileType(newFileType);
                            if (!(fileOptions.getFolder().equals(oldParent) && oldName.equals(newName) && oldFileType.equals((Object)newFileType))) {
                                GraphEditorSupport.this.movePrimaryFile(fileOptions);
                                GraphEditorSupport.this.waitABit();
                                GraphDataObject copy = (GraphDataObject)dataObj.copy(DataFolder.findFolder((FileObject)oldParent));
                                GraphEditorSupport.this.waitABit();
                                copy.setFileType(oldFileType);
                                copy.rename(oldName);
                            }
                            dataObj.setPassword(fileOptions.getPassword());
                            GraphEditorSupport.this.saveImpl(dataObj);
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        WindowUtil.hideWaitCursor();
                    }
                }
            }
        });
    }

    private void saveImpl(GraphDataObject dataObj) {
        boolean saveInEDT = true;
        boolean encrypted = !StringUtilities.isNullOrEmpty((String)dataObj.getPassword());
        SaveGraphEvent.send(encrypted);
        SaveWithProgress swp = new SaveWithProgress(dataObj, dataObj.getPassword(), dataObj.getFileType());
        SlownessDetector.setEnabled((boolean)false);
        WindowUtil.showWaitCursor();
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)"Saving graph");
        handle.start();
        FileObject newFile = swp.run(handle);
        handle.finish();
        this.onSaveDone(dataObj, newFile);
        WindowUtil.hideWaitCursor();
        SlownessDetector.setEnabled((boolean)true);
    }

    private void onSaveDone(GraphDataObject dataObj, FileObject newFile) {
        if (newFile != null) {
            GraphID maltegoGraphID;
            CloudGraphRegistry cloudGraphRegistry = CloudGraphRegistry.getDefault();
            if (cloudGraphRegistry.isCloudGraph(maltegoGraphID = dataObj.getGraphID()) && !cloudGraphRegistry.isEditable(maltegoGraphID)) {
                cloudGraphRegistry.removeCloudGraph(maltegoGraphID);
                RecentCloudGraphs.getDefault().removeCloudGraph(maltegoGraphID.toString());
            } else if (cloudGraphRegistry.isVersionOfCloudGraph(maltegoGraphID)) {
                cloudGraphRegistry.removeVersionOfCloudGraph(maltegoGraphID);
            }
            dataObj.setModified(false);
            StatusDisplayer.getDefault().setStatusText(this.savedMessage((DataObject)dataObj));
        }
    }

    private void saveCloudGraphAsLocalGraph(GraphDataObject dataObj, FileOptions fileOptions, GraphFileType newFileType, String newName) throws IOException {
        this.waitABit();
        GraphDataObject copy = (GraphDataObject)dataObj.copy(DataFolder.findFolder((FileObject)fileOptions.getFolder()));
        this.waitABit();
        File newFile = fileOptions.getFile();
        if (newFile.exists()) {
            FileUtil.toFileObject((File)newFile).delete();
        }
        copy.setFileType(newFileType);
        copy.rename(newName);
        copy.setPassword(fileOptions.getPassword());
        RecentFiles.getInstance().addFile(Utilities.toURI((File)fileOptions.getFile()).toURL().toString());
        this.saveImpl(copy);
        NotifyDescriptor nd = new NotifyDescriptor((Object)"Would you like to open the saved local copy of the cloud graph?", "Open Local Graph File", 0, 1, null, NotifyDescriptor.YES_OPTION);
        Object selectedOption = DialogDisplayer.getDefault().notify(nd);
        if (NotifyDescriptor.YES_OPTION.equals(selectedOption)) {
            OpenCookie oc = (OpenCookie)copy.getLookup().lookup(OpenCookie.class);
            if (oc == null) {
                throw new IOException("Error on opening local copy of the cloud graph");
            }
            oc.open();
        }
    }

    private void movePrimaryFile(FileOptions fileOptions) throws IOException {
        GraphDataObject dataObj = this.getGraphDataObject();
        this.movePrimaryFileForDataObject(dataObj, fileOptions);
    }

    private void movePrimaryFileForDataObject(GraphDataObject dataObj, FileOptions fileOptions) throws IOException {
        File newFile = fileOptions.getFile();
        if (newFile.exists()) {
            FileUtil.toFileObject((File)newFile).delete();
        }
        this.waitABit();
        String filename = fileOptions.getFilename();
        String name = filename.replaceFirst("\\.[^.]+$", "");
        dataObj.move(DataFolder.findFolder((FileObject)fileOptions.getFolder()));
        this.waitABit();
        dataObj.renamePrimaryFile(name, false);
        RecentFiles.getInstance().addFile(Utilities.toURI((File)fileOptions.getFile()).toURL().toString());
    }

    private Boolean showSaveToDiskOrCloudDialog(String graphName) {
        String diskOption = "Local Drive";
        String cloudOption = "Cloud";
        String cancelOption = "Cancel";
        NotifyDescriptor nd = new NotifyDescriptor((Object)("Graph \"" + graphName + "\" was opened as Read Only!\nDo you want to save your changes to a graph on your Local Drive or as a new graph to Cloud?"), "Save to Local Drive or Cloud", 1, 2, new Object[]{diskOption, cloudOption, cancelOption}, (Object)diskOption);
        DialogDisplayer.getDefault().notify(nd);
        Object chosenOption = nd.getValue();
        if (chosenOption.equals(diskOption)) {
            return true;
        }
        if (chosenOption.equals(cloudOption)) {
            return false;
        }
        return null;
    }

    private boolean showSaveToDiskDialog(String graphName, String title, String state) {
        return this.showSaveToDiskDialog(graphName, title, state, "");
    }

    private boolean showSaveToDiskDialog(String graphName, String title, String state, String warning) {
        String saveOption = "Save As";
        String dontSaveOption = "Don't Save";
        String cancelOption = "Cancel";
        NotifyDescriptor nd = new NotifyDescriptor((Object)("Graph \"" + graphName + "\"" + state + "Do you want to save your changes to a graph on your Local Drive?" + warning), title, 1, 2, new Object[]{saveOption, dontSaveOption, cancelOption}, (Object)saveOption);
        DialogDisplayer.getDefault().notify(nd);
        return nd.getValue().equals(saveOption);
    }

    private FileOptions showSaveAsDialog(GraphDataObject oldDobj) {
        FileOptions options = null;
        String title = NbBundle.getMessage(GraphEditorSupport.class, (String)"MSG_SaveTitle");
        FileChooserBuilder chooser = new FileChooserBuilder(GraphEditorSupport.class).setTitle(title);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addFileFilter((FileFilter)new GraphFileFilter(GraphFileType.PANDORA));
        chooser.addFileFilter((FileFilter)new GraphFileFilter(GraphFileType.GRAPHML));
        JFileChooser fileChooser = chooser.createFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setSelectedFile(new File(oldDobj.getPrimaryFile().getName()));
        JCheckBox embedCheckBox = new JCheckBox();
        embedCheckBox.setSelected(ImageCacheSerializer.isEnabled());
        JCheckBox encryptCheckBox = new JCheckBox();
        encryptCheckBox.setSelected(false);
        FileChooserUtil.addAdditionalFieldsToChooser((JFileChooser)fileChooser, (String[])new String[]{"Embed web images:", "Encrypt (AES-128):"}, (JComponent[])new JComponent[]{embedCheckBox, encryptCheckBox});
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        if (fileChooser.showSaveDialog(mainWindow) == 0) {
            File file;
            String password = null;
            ImageCacheSerializer.setEnabled((boolean)embedCheckBox.isSelected());
            if (encryptCheckBox.isSelected() && (password = PasswordUtil.getPasswordInput((boolean)true)) == null) {
                return null;
            }
            GraphFileFilter selectedFilter = (GraphFileFilter)fileChooser.getFileFilter();
            GraphFileType selectedType = selectedFilter.getType();
            String extension = selectedType.getExtension();
            File f = fileChooser.getSelectedFile();
            File parentFile = f.getParentFile();
            String filename = f.getName();
            FileObject folder = FileUtil.toFileObject((File)parentFile);
            if (!filename.toLowerCase().endsWith("." + extension.toLowerCase())) {
                filename = filename + "." + extension;
            }
            if ((file = new File(parentFile, filename)).exists()) {
                String overwriteMessage = NbBundle.getMessage(GraphEditorSupport.class, (String)"MSG_Overwrite", (Object)filename);
                Object userChose = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)overwriteMessage));
                if (!NotifyDescriptor.OK_OPTION.equals(userChose)) {
                    return null;
                }
            }
            options = new FileOptions(file, folder, filename, password, selectedType);
        }
        return options;
    }

    @Override
    protected boolean close(boolean ask) {
        return super.close(ask);
    }

    public void open() {
        FileObject primaryFile;
        File file;
        boolean canOpen = true;
        GraphID graphID = this.getGraphDataObject().getGraphID();
        if (graphID != null) {
            try {
                CloudGraphRegistry cloudGraphRegistry;
                if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID) && ((cloudGraphRegistry = CloudGraphRegistry.getDefault()).isCloudGraph(graphID) || cloudGraphRegistry.isVersionOfCloudGraph(graphID))) {
                    canOpen = false;
                    String msg = "Cloud graph version already open: ";
                    TopComponent topComponent = GraphDataUtils.getTopComponent(graphID);
                    if (topComponent != null) {
                        topComponent.requestActive();
                        StatusDisplayer.getDefault().setStatusText(msg + graphID);
                    } else {
                        StatusDisplayer.getDefault().setStatusText(msg + graphID + ". Open tab not found");
                    }
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (canOpen && this.getGraphDataObject().getPassword() == null && (file = FileUtil.toFile((FileObject)(primaryFile = this.getGraphDataObject().getPrimaryFile()))) != null) {
            try {
                ZipFile zipFile = new ZipFile(file);
                if (zipFile.isEncrypted()) {
                    String password = PasswordUtil.promptForPassword((ZipFile)zipFile);
                    boolean bl = canOpen = password != null;
                    if (canOpen) {
                        this.getGraphDataObject().setPassword(password);
                    }
                }
                this.getGraphDataObject().setFileType(GraphFileType.forFile((String)file.getName()));
            }
            catch (ZipException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (canOpen) {
            super.open();
        }
    }

    private void waitABit() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class FileOptions {
        private final File _file;
        private final FileObject _folder;
        private final String _filename;
        private final String _password;
        private final GraphFileType _type;

        public FileOptions(File file, FileObject folder, String filename, String password, GraphFileType type) {
            this._file = file;
            this._folder = folder;
            this._filename = filename;
            this._password = password;
            this._type = type;
        }

        public File getFile() {
            return this._file;
        }

        public FileObject getFolder() {
            return this._folder;
        }

        public String getFilename() {
            return this._filename;
        }

        public String getPassword() {
            return this._password;
        }

        public GraphFileType getGraphFileType() {
            return this._type;
        }

        public String toString() {
            return "FileOptions{file=" + this._file + ", folder=" + this._folder + ", filename=" + this._filename + ", password=" + this._password + ", type=" + this._type + '}';
        }
    }

    private class SaveWithProgress
    implements ProgressRunnable<FileObject>,
    Cancellable {
        private final GraphDataObject _gdp;
        private String _filename;
        private final AtomicBoolean _cancelled = new AtomicBoolean(false);
        private ZipParameters _zipParams;
        private final GraphFileType _fileType;

        public SaveWithProgress(GraphDataObject gdp, String password, GraphFileType fileType) {
            this._gdp = gdp;
            this.setPassword(password);
            this._fileType = fileType;
        }

        private void setPassword(String password) {
            this._zipParams = PasswordUtil.getZipParameters((String)password);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject run(ProgressHandle handle) {
            OutputStream os = null;
            FileObject newFile = null;
            try {
                FileObject fo = this._gdp.getPrimaryFile();
                this._filename = fo.getName();
                LOG.log(Level.INFO, "Saving {0}", this._filename);
                if (this._zipParams == null) {
                    os = new BufferedOutputStream(fo.getOutputStream());
                    this._gdp.saveGraph(GraphEditorSupport.this.getSaveProxy(), os, handle, this._cancelled, this._fileType);
                } else {
                    try {
                        File file = FileUtil.toFile((FileObject)fo);
                        if (file.exists()) {
                            file.delete();
                        }
                        ZipFile zipFile = new ZipFile(file);
                        this._gdp.saveGraph(GraphEditorSupport.this.getSaveProxy(), zipFile, this._zipParams, handle, this._cancelled, this._fileType);
                    }
                    catch (ZipException ex) {
                        throw new IOException(ex);
                    }
                }
                newFile = fo;
            }
            catch (UserCancelException ex) {
                StatusDisplayer.getDefault().setStatusText("Save cancelled");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                String msg = NbBundle.getMessage(GraphEditorSupport.class, (String)"MSG_SaveFailed", (Object)this._filename);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)ex, (Object)msg));
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return newFile;
        }

        public boolean cancel() {
            NotifyDescriptor.Confirmation msg = new NotifyDescriptor.Confirmation((Object)"Are you sure you want to cancel?", "Cancel", 2, 3);
            if (NotifyDescriptor.Confirmation.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)msg))) {
                this._cancelled.set(true);
                return true;
            }
            return false;
        }
    }
}

