/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeLabel;
import com.paterva.maltego.ui.graph.view2d.EditLabelAction;
import com.paterva.maltego.ui.graph.view2d.EntityLabelConfigs;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.I.M;
import yguard.A.J.MC;
import yguard.A.J.X;
import yguard.A.J.gB;
import yguard.A.J.mB;

public class EditNotesViewMode
extends mB {
    private int _mouseX;
    private int _mouseY;

    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        this._mouseX = me.getX();
        this._mouseY = me.getY();
    }

    public void mouseReleased(MouseEvent me) {
        gB label;
        double worldY;
        double worldX;
        MC hitInfo;
        super.mouseReleased(me);
        if (this.view.getZoom() >= this.view.getPaintDetailThreshold() && this._mouseX == me.getX() && this._mouseY == me.getY() && (hitInfo = this.getHitInfo(worldX = this.view.toWorldCoordX(me.getX()), worldY = this.view.toWorldCoordY(me.getY()))).F() && (label = hitInfo.Y()) != null && !(label instanceof CollectionNodeLabel) && this.isNotesEditLabel(label)) {
            if (this.isCloseClicked(label, worldX, worldY)) {
                MaltegoEntity entity = this.getEntity(label.getNode());
                String notes = entity.getNotes();
                boolean isShowNotes = false;
                if ("(Click here to add notes)".equals(notes)) {
                    notes = "";
                }
                GraphTransactionHelper.doChangeNotes((D)this.getGraph2D(), Collections.singleton(entity), notes, isShowNotes);
            } else {
                this.notesEditLabelClicked(label);
            }
        }
    }

    private boolean isCloseClicked(gB label, double worldX, double worldY) {
        Point2D.Double pos = this.getLabelClickLocation(label, worldX, worldY);
        Rectangle2D.Double notesCloseRect = EntityLabelConfigs.getNotesCloseRect((X)label);
        notesCloseRect.x -= 1.0;
        notesCloseRect.y -= 1.0;
        notesCloseRect.width += 2.0;
        notesCloseRect.height += 2.0;
        return notesCloseRect.contains(pos);
    }

    private Point2D.Double getLabelClickLocation(gB label, double worldX, double worldY) {
        Y node = label.getNode();
        double nodeX = this.view.getGraph2D().U(node);
        double nodeY = this.view.getGraph2D().N(node);
        double labelClickX = worldX - (nodeX + label.getOffsetX());
        double labelClickY = worldY - (nodeY + label.getOffsetY());
        return new Point2D.Double(labelClickX, labelClickY);
    }

    private boolean isNotesEditLabel(gB label) {
        gB notesEditLabel = this.view.getGraph2D().f(label.getNode()).getLabel(4);
        return notesEditLabel != null && notesEditLabel.equals(label);
    }

    private void notesEditLabelClicked(gB notesEditLabel) {
        int margin = 10;
        M textLocation = notesEditLabel.getTextLocation().A((double)margin, (double)margin);
        EditLabelAction action = new EditLabelAction();
        action.startEditing(this.view, (X)notesEditLabel);
        this.view.openLabelEditor((X)notesEditLabel, textLocation.A, textLocation.D, (PropertyChangeListener)new NotesListener(notesEditLabel));
    }

    private MaltegoEntity getEntity(Y node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)this.view.getGraph2D());
        MaltegoEntity entity = wrapper.entity(node);
        return entity;
    }

    private void setNotes(MaltegoEntity entity, String newNotes, boolean isShowNotes) {
        GraphTransactionHelper.doChangeNotes((D)this.getGraph2D(), Collections.singleton(entity), newNotes, isShowNotes);
    }

    private class NotesListener
    implements PropertyChangeListener {
        private gB _label;

        private NotesListener(gB label) {
            this._label = label;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)this._label.getGraph2D());
            MaltegoEntity entity = wrapper.entity(this._label.getNode());
            String text = this._label.getText();
            if (text == null || text.trim().isEmpty()) {
                EditNotesViewMode.this.setNotes(entity, "", false);
            } else {
                EditNotesViewMode.this.setNotes(entity, text, entity.isShowNotes());
            }
        }
    }
}

