/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.prompts.choice.controls;

import com.maltego.tx3.java.api.execution.ButtonChoicePromptControl;
import com.maltego.tx3.java.api.execution.ChoicePrompt;
import com.maltego.tx3.java.api.execution.TransformRunChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunPromptResponse;
import com.paterva.maltego.transform.protocol.v3.JButtonAutoAccept;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.PromptControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;

public class ButtonPromptControl
extends PromptControl {
    private final JButton[] buttonOptions;
    private final JButton defaultButtonOption;
    protected final Map<String, String> options;

    public ButtonPromptControl(String transforName, TransformRunChoicePromptEvent prompt) {
        super(transforName, prompt.getMessage(), prompt.getTimeout());
        this.options = prompt.getOptions().stream().collect(Collectors.toMap(ChoicePrompt::getId, ChoicePrompt::getDisplayName));
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        if (prompt.getControl() != null && prompt.getControl().getOptions() != null) {
            this.options.putAll(prompt.getControl().getOptions().stream().collect(Collectors.toMap(c -> c.getId(), c -> c.getDisplayName())));
        }
        int defaultButtonIndex = 0;
        for (int i = 0; i < this.options.size(); ++i) {
            ChoicePrompt choicePrompt = (ChoicePrompt)prompt.getOptions().get(i);
            boolean isDefaultButton = false;
            if (prompt.getDefaultOptionId() != null) {
                isDefaultButton = choicePrompt.getId().equals(prompt.getDefaultOptionId());
            } else if (prompt.getControl() != null) {
                ButtonChoicePromptControl button = (ButtonChoicePromptControl)prompt.getControl();
                isDefaultButton = choicePrompt.getId().equals(button.getDefaultOptionId());
            }
            if (isDefaultButton) {
                JButtonAutoAccept autoButton = new JButtonAutoAccept(choicePrompt.getDisplayName(), prompt.getTimeout());
                autoButton.setName(choicePrompt.getId());
                buttons.add(autoButton);
                defaultButtonIndex = i;
                continue;
            }
            JButton choiceButton = new JButton(choicePrompt.getDisplayName());
            choiceButton.setName(choicePrompt.getId());
            buttons.add(choiceButton);
        }
        buttons.add(this.getCancelButton());
        this.buttonOptions = (JButton[])buttons.stream().toArray(JButton[]::new);
        this.defaultButtonOption = this.buttonOptions[defaultButtonIndex];
        this.resize();
    }

    @Override
    public DialogDescriptor getDialogDescriptor() {
        return new DialogDescriptor((Object)this.getFormPanel(), "Additional Transform Input", true, (Object[])this.buttonOptions, (Object)this.defaultButtonOption, 0, HelpCtx.DEFAULT_HELP, null);
    }

    @Override
    public TransformRunPromptResponse handleResponse(Object result) {
        TransformRunPromptResponse.ResponseReason reason = TransformRunPromptResponse.ResponseReason.COMPLETED;
        HashMap<String, String> response = new HashMap<String, String>();
        if (result != null && (reason = this.getReason(result, reason)) != TransformRunPromptResponse.ResponseReason.CANCELLED) {
            JButton resultButton = (JButton)result;
            response.put(resultButton.getName(), this.options.get(resultButton.getName()));
        }
        return new TransformRunPromptResponse(reason, response);
    }
}

