/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.cases;

import com.maltego.cloud.data.OrganizationSettings;
import com.maltego.cloud.rest.GraphStoreRestClient;
import com.maltego.cloud.ui.cases.NewCaseSelection;
import com.paterva.maltego.util.NormalException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NewCasePanel
extends JPanel {
    private RequestProcessor rp = new RequestProcessor("New Case", 1);
    private JLabel caseNameLabel;
    private JTextField caseNameTextField;
    private JCheckBox encryptedCheckBox;
    private JLabel encryptedLabel;
    private JPanel newCasePanel;
    private JProgressBar progressBar;
    private JPanel progressPanel;

    public NewCasePanel() {
        this.initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, "progress");
        this.rp.post(() -> {
            try {
                OrganizationSettings orgSettings = GraphStoreRestClient.fetchOrganizationSettings();
                SwingUtilities.invokeLater(() -> {
                    if (orgSettings.isMandatoryEncryption()) {
                        this.encryptedCheckBox.setSelected(true);
                        this.encryptedCheckBox.setEnabled(false);
                        this.encryptedCheckBox.setToolTipText("Encryption is enforced by your organization");
                    }
                    layout.show(this, "newCase");
                });
            }
            catch (IOException ex) {
                NormalException.logStackTrace((Throwable)ex);
                String errorMessage = "Fetching organization settings failed: " + ex.getMessage();
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)errorMessage, 0);
                msg.setTitle("Create New Case");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        });
    }

    @Override
    public void removeNotify() {
        this.rp.shutdownNow();
        super.removeNotify();
    }

    public static NewCaseSelection show(final String[] existingCases) {
        final NewCasePanel newCasePanel = new NewCasePanel();
        final NotifyDescriptor nd = new NotifyDescriptor((Object)newCasePanel, "Create New Case", 2, -1, null, NotifyDescriptor.OK_OPTION);
        final NotificationLineSupport nls = nd.createNotificationLineSupport();
        nls.clearMessages();
        nd.setValid(false);
        newCasePanel.caseNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String text = newCasePanel.caseNameTextField.getText().trim();
                if (text.isEmpty()) {
                    nls.clearMessages();
                    nd.setValid(false);
                    return;
                }
                for (String existingCase : existingCases) {
                    if (!existingCase.equals(text)) continue;
                    nls.setWarningMessage("Case exists, please enter another name");
                    nd.setValid(false);
                    return;
                }
                nls.clearMessages();
                nd.setValid(true);
            }
        });
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify(nd))) {
            return new NewCaseSelection(newCasePanel.caseNameTextField.getText().trim(), newCasePanel.encryptedCheckBox.isSelected());
        }
        return null;
    }

    private void initComponents() {
        this.newCasePanel = new JPanel();
        this.caseNameLabel = new JLabel();
        this.encryptedLabel = new JLabel();
        this.caseNameTextField = new JTextField();
        this.encryptedCheckBox = new JCheckBox();
        this.progressPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.setLayout(new CardLayout());
        this.newCasePanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.caseNameLabel, (String)NbBundle.getMessage(NewCasePanel.class, (String)"NewCasePanel.caseNameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 25, 5, 5);
        this.newCasePanel.add((Component)this.caseNameLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.encryptedLabel, (String)NbBundle.getMessage(NewCasePanel.class, (String)"NewCasePanel.encryptedLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 10, 5);
        this.newCasePanel.add((Component)this.encryptedLabel, gridBagConstraints);
        this.caseNameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 25);
        this.newCasePanel.add((Component)this.caseNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 25);
        this.newCasePanel.add((Component)this.encryptedCheckBox, gridBagConstraints);
        this.add((Component)this.newCasePanel, "newCase");
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString(NbBundle.getMessage(NewCasePanel.class, (String)"NewCasePanel.progressBar.string"));
        this.progressBar.setStringPainted(true);
        GroupLayout progressPanelLayout = new GroupLayout(this.progressPanel);
        this.progressPanel.setLayout(progressPanelLayout);
        progressPanelLayout.setHorizontalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, progressPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.progressBar, -1, 176, Short.MAX_VALUE).addGap(25, 25, 25)));
        progressPanelLayout.setVerticalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progressPanelLayout.createSequentialGroup().addContainerGap(32, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addContainerGap(32, Short.MAX_VALUE)));
        this.add((Component)this.progressPanel, "progress");
    }
}

