/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.ComplexTypeConverter;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

class MapConverter
extends ComplexTypeConverter<Map> {
    public MapConverter() {
        super("map", Map.class);
    }

    @Override
    protected void writeImpl(Map value, String field, Document to) throws PandoraException {
        Map map = value;
        for (Map.Entry child : map.entrySet()) {
            this.writeChild(field, (String)child.getKey(), child.getValue(), to);
        }
    }

    @Override
    protected Map<String, Object> readComplexImpl(List<IndexableField> fields, String prefix) throws PandoraException {
        return this.readChildrenAsMap(fields, prefix);
    }

    @Override
    public boolean canReadChildSubset() {
        return true;
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) {
        throw new UnsupportedOperationException("A map field cannot be filtered directly. Instead specify a sub property to filter on.");
    }

    @Override
    protected Query createEmptyFilterImpl(String property) {
        throw new UnsupportedOperationException("A map field does not support filtering on NULL values.");
    }

    @Override
    protected Query createNotEmptyFilterImpl(String property) {
        throw new UnsupportedOperationException("A map field does not support filtering on NULL values.");
    }

    @Override
    protected SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        throw new UnsupportedOperationException("A map field cannot be sorted directly. Instead specify a sub property to sort on.");
    }
}

