/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class MaltegoSpecComboRenderer
extends BasicComboBoxRenderer {
    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String displayValue = MaltegoSpecComboRenderer.getComboDisplayValue(value);
        if (displayValue != null) {
            this.setComboText(displayValue);
        }
        if (value != null && list != null && list.getModel() != null) {
            if (index == -1) {
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    Object item = list.getModel().getElementAt(i);
                    if (!value.equals(item)) continue;
                    index = i;
                    break;
                }
            }
            if (index > -1 && displayValue != null) {
                list.setToolTipText(displayValue);
            }
        }
        return this;
    }

    private void setComboText(String displayValue) {
        this.setText(StringUtilities.chomp((String)displayValue, (int)60, (String)"..."));
    }

    public static String getComboDisplayValue(Object value) {
        String displayValue = null;
        if (value instanceof MaltegoEntitySpec) {
            MaltegoEntitySpec item = (MaltegoEntitySpec)value;
            displayValue = item.getDisplayName() + " [" + item.getTypeName() + "]";
        } else if (value instanceof MaltegoLinkSpec) {
            MaltegoLinkSpec item = (MaltegoLinkSpec)value;
            displayValue = item.getDisplayName() + " [" + item.getTypeName() + "]";
        } else if (value instanceof String) {
            displayValue = (String)value;
        }
        return displayValue;
    }
}

