/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dnd;

import com.paterva.maltego.util.ui.dnd.MaltegoDropHandler;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class MaltegoGlobalDropHandler
implements MaltegoDropHandler,
DropTargetListener {
    private static final MaltegoGlobalDropHandler INSTANCE = new MaltegoGlobalDropHandler();
    private final List<MaltegoDropHandler> dropHandlers = new ArrayList<MaltegoDropHandler>(Lookup.getDefault().lookupAll(MaltegoDropHandler.class));

    private MaltegoGlobalDropHandler() {
    }

    public static MaltegoGlobalDropHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean allowDrop(Transferable t) {
        return this.dropHandlers.stream().anyMatch(handler -> handler.allowDrop(t));
    }

    @Override
    public boolean handleDrop(Transferable t) {
        return this.dropHandlers.stream().filter(handler -> handler.allowDrop(t)).findFirst().map(handler -> handler.handleDrop(t)).orElse(false);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (Utilities.isMac() || this.allowDrop(dtde.getTransferable())) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(2);
        Transferable t = dtde.getTransferable();
        if (!Utilities.isMac() || this.allowDrop(t)) {
            this.handleDrop(dtde.getTransferable());
        }
    }
}

