/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.sets;

import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.sets.TransformSetForm;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import org.openide.WizardDescriptor;

class TransformSetFormController
extends ValidatingController<TransformSetForm> {
    protected String getFirstError(TransformSetForm component) {
        TransformSetRepository registry;
        String name = component.getSetName().trim();
        if (name.length() == 0) {
            return "Set name is required";
        }
        if (!this.checkChars(name)) {
            return "Set name contains invalid characters.";
        }
        if (!this.isEditMode() && (registry = (TransformSetRepository)this.getDescriptor().getProperty("setRepository")).contains(name)) {
            return "The name '" + name + "' is already in use";
        }
        return null;
    }

    protected TransformSetForm createComponent() {
        TransformSetForm f = new TransformSetForm();
        f.addChangeListener(this.changeListener());
        return f;
    }

    protected boolean isEditMode() {
        return this.getDescriptor().getProperty("editMode") == Boolean.TRUE;
    }

    private boolean checkChars(String id) {
        for (char c : id.toCharArray()) {
            if (Character.isLetter(c) || c == '.' || c == ' ' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    protected void readSettings(WizardDescriptor settings) {
        ((TransformSetForm)this.component()).setSetName((String)settings.getProperty("setName"));
        ((TransformSetForm)this.component()).setDescription((String)settings.getProperty("setDescription"));
        ((TransformSetForm)this.component()).setNameEnabled(!this.isEditMode());
    }

    protected void storeSettings(WizardDescriptor settings) {
        settings.putProperty("setName", (Object)((TransformSetForm)this.component()).getSetName());
        settings.putProperty("setDescription", (Object)((TransformSetForm)this.component()).getDescription());
    }
}

