/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core2.network.proxy;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.RequestProcessor;

public class LocalAddressUtil {
    private static final Logger LOG = Logger.getLogger(LocalAddressUtil.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("NetworkAddressFinder", 2);
    private static InetAddress addrLocalNetIf;
    private static InetAddress addrLocalHost;
    private static final RequestProcessor.Task task1;
    private static final RequestProcessor.Task task2;
    private static final Object lock1;
    private static final Object lock2;

    public static InetAddress getLocalNetworkInterfaceAddr() {
        if (task1.isFinished()) {
            return LocalAddressUtil.getAddrLocalNetIf();
        }
        task1.waitFinished();
        return LocalAddressUtil.getAddrLocalNetIf();
    }

    public static InetAddress getLocalHostAddr() {
        if (task2.isFinished()) {
            return LocalAddressUtil.getAddrLocalHost();
        }
        task2.waitFinished();
        return LocalAddressUtil.getAddrLocalHost();
    }

    public static void refreshLocalNetworkInterfaceAddr() {
        LocalAddressUtil.setAddrLocalNetIf(LocalAddressUtil.getLocalNetworkInterfaceAddr2());
    }

    public static void refreshLocalHostAddr() {
        LocalAddressUtil.setAddrLocalHost(LocalAddressUtil.getLocalHostAddr2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getAddrLocalNetIf() {
        Object object = lock1;
        synchronized (object) {
            return addrLocalNetIf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAddrLocalNetIf(InetAddress addr) {
        Object object = lock1;
        synchronized (object) {
            addrLocalNetIf = addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getAddrLocalHost() {
        Object object = lock2;
        synchronized (object) {
            return addrLocalHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAddrLocalHost(InetAddress addr) {
        Object object = lock2;
        synchronized (object) {
            addrLocalHost = addr;
        }
    }

    private static InetAddress getLocalNetworkInterfaceAddr2() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            LOG.log(Level.WARNING, "Cannot get host's network interfaces", ex);
            return null;
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface netIf = interfaces.nextElement();
            try {
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                if (netIf.isVirtual()) {
                }
            }
            catch (SocketException ex) {}
            continue;
            Enumeration<InetAddress> addresses = netIf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet4Address)) continue;
                return address;
            }
        }
        return null;
    }

    private static InetAddress getLocalHostAddr2() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet4Address && !localHost.isLoopbackAddress()) {
                return localHost;
            }
        }
        catch (UnknownHostException ex) {
            return null;
        }
        return null;
    }

    static {
        lock1 = new Object();
        lock2 = new Object();
        task1 = RP.post(new Runnable(){

            @Override
            public void run() {
                LocalAddressUtil.setAddrLocalNetIf(LocalAddressUtil.getLocalNetworkInterfaceAddr2());
            }
        });
        task2 = RP.post(new Runnable(){

            @Override
            public void run() {
                LocalAddressUtil.setAddrLocalHost(LocalAddressUtil.getLocalHostAddr2());
            }
        });
    }
}

