/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.gcap.especie;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.app.acoes.ImportarGCAPAction;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gcap.especie.ColecaoTotalizacaoMoedasAlienadas;
import serpro.ppgd.irpf.gcap.especie.TotalizacaoMoedasAlienadas;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.gcap.especie.PainelAbaConsolidacaoMoeda;
import serpro.ppgd.irpf.gui.gcap.especie.TableModelTotalizacoesEspecie;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaListaConsolidacoesEspecie
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Consolida\u00e7\u00e3o";
    public static final String NOME_ABA = "Consolida\u00e7\u00e3o";
    public static final String HELP_ID = "Demonstrativo de Ganhos de Capital (GCAP 2022)";
    private PainelDemonstrativoIf painelPai;

    public PainelAbaListaConsolidacoesEspecie() {
        this.ajustarToolBarImportar();
    }

    public PainelAbaListaConsolidacoesEspecie(Colecao<? extends ObjetoNegocio> colecao) {
        super(colecao);
        this.ajustarToolBarImportar();
    }

    public PainelAbaListaConsolidacoesEspecie(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
        this.ajustarToolBarImportar();
    }

    public void onBtnNovoClick(ActionEvent e) {
        new ImportarGCAPAction().executarAcao(null);
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableListaModel model = (TableListaModel)this.getTabela().getModel();
            ColecaoTotalizacaoMoedasAlienadas totalizacoes = (ColecaoTotalizacaoMoedasAlienadas)model.getObjetoNegocio();
            TotalizacaoMoedasAlienadas totalizacao = (TotalizacaoMoedasAlienadas)totalizacoes.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelAbaConsolidacaoMoeda(this.painelPai, totalizacao));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRowCount() <= 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount() - 1)) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirma((String)"gcap_excluir_cpf")) {
                ArrayList<TotalizacaoMoedasAlienadas> listaRemocao = new ArrayList<TotalizacaoMoedasAlienadas>(linhasTabela.length);
                ColecaoTotalizacaoMoedasAlienadas colecao = null;
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
                    colecao = (ColecaoTotalizacaoMoedasAlienadas)model.getObjetoNegocio();
                    listaRemocao.add((TotalizacaoMoedasAlienadas)colecao.itens().get(indiceVetor));
                }
                Object object = listaRemocao.iterator();
                while (object.hasNext()) {
                    TotalizacaoMoedasAlienadas alienacao = (TotalizacaoMoedasAlienadas)object.next();
                    ControladorGui.getDemonstrativoAberto().getGCAP().removerDemonstrativo((ObjetoGCAP)alienacao);
                }
                ControladorGui.getDemonstrativoAberto().getGCAP().recalcularConsolidacoes();
                ControladorGui.getDemonstrativoAberto().getGCAP().recalcularGCAPDeclaracaoIRPF();
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(850);
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "CPF do Alienante"};
        return tableLista;
    }

    protected String getClassePainelNavegacao() {
        return null;
    }

    protected String getButtonHelpID() {
        return HELP_ID;
    }

    protected TableListaModel getTableModel() {
        return new TableModelTotalizacoesEspecie((ObjetoNegocio)ControladorGui.getDemonstrativoAberto().getGCAP().getColecaoTotalizacaoMoedasAlienadas());
    }

    protected int getColunaOrdenacao() {
        return 0;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"totaliza\u00e7\u00f5es"};
    }

    public String getTituloPainel() {
        return "Consolida\u00e7\u00e3o";
    }

    public boolean isTelaComFavoritos() {
        return true;
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/ME_especie.png");
    }
}

